/* global jQuery */

( function() {
	"use strict";

	var $document = jQuery(document);

	$document.on( 'action.before_ready_trx_addons', function() {

		// Init Superfish menu - global declaration to use in other scripts
		window.trx_addons_init_sfmenu = function( selector ) {

			jQuery( selector ).show().each( function() {

				var $self = jQuery( this );

				var is_touch_device = ( 'ontouchstart' in document.documentElement );

				var animation_in = $self.parent().data( 'animation-in' );
				if ( animation_in == undefined || is_touch_device ) {
					animation_in = "none";
				}
				var animation_out = $self.parent().data( 'animation-out' );
				if ( animation_out == undefined || is_touch_device ) {
					animation_out = "none";
				}

				var sf_init = {

					delay:		300,
					speed: 		animation_in  != 'none' ? 500 : 200,
					speedOut:	animation_out != 'none' ? 300 : 200,
					autoArrows: false,
					dropShadows:false,

					onBeforeShow: function() {
						jQuery( this ).each( function() {
							var menu_item = jQuery( this ).data( 'menu-state', 'before-show' );
							if ( menu_item.hasClass('sc_layouts_submenu') && ! menu_item.hasClass('layouts_inited') && menu_item.find('.slider_container').length > 0 ) {
								menu_item.addClass('sc_layouts_submenu_prepare');
							} else {
								trx_addons_do_action( 'trx_addons_action_menu_on_before_show', menu_item );
								trx_addons_before_show_menu(menu_item);
							}
						} );
					},

					onShow: function() {
						jQuery( this ).each( function() {
							var menu_item = jQuery( this );
							if ( menu_item.data( 'menu-state' ) != 'before-show' ) {
								trx_addons_do_action( 'trx_addons_action_menu_on_show', menu_item );
								trx_addons_before_show_menu(menu_item);
							}
							menu_item.data('menu-state', 'show');
							trx_addons_do_action( 'trx_addons_action_menu_after_show', menu_item );
							trx_addons_after_show_menu(menu_item);

						} );
					},

					onBeforeHide: function() {
						jQuery( this ).each( function() {
							var menu_item = jQuery( this );
							if ( menu_item.data( 'menu-state' ) == 'show' ) {
								menu_item.data('menu-state', 'before-hide');
								trx_addons_do_action( 'trx_addons_action_menu_on_before_hide', menu_item );
								trx_addons_before_hide_menu(menu_item);
							}
						} );
					},

					onHide: function() {
						jQuery(this).each( function() {
							var menu_item = jQuery( this ).data('menu-state', 'hide');
							trx_addons_do_action( 'trx_addons_action_menu_on_hide', menu_item );
							trx_addons_after_hide_menu(menu_item);
						} );
					},

					onHandleTouch: function() {
						// Hack for iPad - disallow hide parents submenus on open nested level to prevent blink effect
						var $ul = jQuery( this ).parents('ul');
						if ( trx_addons_browser_is_ios() && $ul.length > 1 ) {
							$ul.addClass('sc_layouts_submenu_freeze');
							setTimeout( function() {
								$ul.removeClass('sc_layouts_submenu_freeze');
							}, 1000 );
						}
					}
				};

				if ( animation_in == 'none' ) {
					sf_init.animation = {
						opacity: 'show'
					};
				}
				if ( animation_out == 'none' ) {
					sf_init.animationOut = {
						opacity: 'hide'
					};
				}

				// Prevent close a submenu with layout '.sc_layouts_submenu' after click on any element with tabindex (can got focus)
				// and next click on the empty place inside the submenu layout.
				$self.find( '.sc_layouts_submenu_wrap' ).on( 'focusout', function( e ) {
					if ( e.currentTarget && jQuery( e.currentTarget ).hasClass( 'sc_layouts_submenu_wrap' ) ) {
						e.stopPropagation();
						return false;
					}
				} );

				// Init SuperFish
				$self.addClass('inited').superfish( trx_addons_apply_filters( 'trx_addons_filter_menu_init_args', sf_init ) );

				// Before show submenu
				function trx_addons_before_show_menu(menu_item) {
					// Disable show submenus in the vertical menu on the mobile screen
					//if (jQuery(window).width() < 768 && menu_item.parents(".sc_layouts_menu_dir_vertical").length > 0)
					//	return false;

					var in_columns = menu_item.parents('li[class*="columns-"]').length > 0
										&& ( ! menu_item.parent().attr('class')
											|| menu_item.parent().attr('class').indexOf('columns-') == -1
											);

					if ( ! in_columns ) {

						// Shift submenu left/right if it is going out of the window
						trx_addons_shift_submenu( menu_item );

						// Animation in
						var animated = false;
						trx_addons_do_action( 'trx_addons_action_menu_before_animation_in', menu_item, animation_in, animation_out );								
						if ( animation_in != 'none' ) {	// && ! menu_item.hasClass('sc_layouts_submenu_freeze')) {
							// To allow theme make own animation - filter handler must return true
							animated = trx_addons_apply_filters( 'trx_addons_filter_menu_animation_in', false, menu_item, animation_in, animation_out );
							if ( ! animated ) {
								if ( menu_item.hasClass('animated') && menu_item.hasClass(animation_out) ) {
									menu_item.removeClass('animated faster '+animation_out);
								}
								menu_item.addClass('animated fast '+animation_in);
								animated = true;
							}
						}

						// Trigger action
						$document.trigger('action.before_show_submenu', [menu_item] );
					}

					return animated;
				}

				// After show submenu
				function trx_addons_after_show_menu(menu_item) {

					// Init layouts
					if ( menu_item.hasClass('sc_layouts_submenu') ) {
						if ( ! menu_item.hasClass('layouts_inited') ) {
							trx_addons_stretch_submenu(menu_item);
							$document.trigger( 'action.init_hidden_elements', [menu_item] );
							if (menu_item.find('.slider_container').length > 0) {
								$document.on('action.slider_inited', function(e, slider, id) {
									trx_addons_before_show_menu(menu_item);
									menu_item
										.removeClass('sc_layouts_submenu_prepare')
										.addClass('layouts_inited');
								});
							} else {
								menu_item.addClass('layouts_inited');
							}
						}
						// Trigger 'resize' action
						$document.trigger('action.resize_trx_addons', [menu_item]);
					}

					// Trigger action
					$document.trigger('action.after_show_submenu', [menu_item] );
				}

				// Before hide submenu
				function trx_addons_before_hide_menu(menu_item) {
					// Remove video
					menu_item.find('.trx_addons_video_player.with_cover.video_play').removeClass('video_play').find('.video_embed').empty();
					
					// Disable show submenus in the vertival menu on the mobile screen
					//if (jQuery(window).width() < 768 && menu_item.parents(".sc_layouts_menu_dir_vertical").length > 0)
					//	return false;
					
					// Animation out
					var animated = false;
					trx_addons_do_action( 'trx_addons_action_menu_before_animation_out', menu_item, animation_in, animation_out );								
					if ( animation_out!='none' ) {	// && ! menu_item.hasClass('sc_layouts_submenu_freeze') ) {
						// To allow theme make own animation - filter handler must return true
						animated = trx_addons_apply_filters( 'trx_addons_filter_menu_animation_out', false, menu_item, animation_in, animation_out );
						if ( ! animated ) {
							if (menu_item.parents('[class*="columns-"]').length === 0 ) {
								if ( menu_item.hasClass('animated') && menu_item.hasClass(animation_in) ) {
									menu_item.removeClass('animated fast '+animation_in);
								}
								if ( menu_item.data('menu-state') == 'show' || menu_item.data('menu-state') == 'before-hide' ) {
									menu_item.addClass('animated faster '+animation_out);
									animated = true;
								}
							}
						}
					}

					// Trigger action
					$document.trigger('action.before_hide_submenu', [menu_item] );

					return animated;
				}

				// After hide submenu
				function trx_addons_after_hide_menu(menu_item) {
					// Restore submenu position after 0.5s (if hidden)
					setTimeout( function() {
						if ( menu_item.data('menu-state') == 'hide' ) {
							// Menu: Delete styles that are set programmatically
							menu_item.removeAttr( 'style' );
							// Menu bg: Delete styles that are set programmatically
							//          and restore background color
							var bg = menu_item.find('> .sc_layouts_menu_stretch_bg');
							if ( bg.length ) {
								bg.removeAttr( 'style' )		
									.css( {
										'background-color': menu_item.css('background-color')
									} );
							}
							// Inner container: Delete styles that are set programmatically
							var container = menu_item.data( 'reset-style' );
							if ( container ) {
								menu_item.find( container ).removeAttr( 'style' );
							}
							// Trigger action
							$document.trigger('action.after_hide_submenu', [menu_item] );
						}
					}, 500 );
				}
			} );
		};

		// Init superfish menus
//		trx_addons_init_sfmenu('.sc_layouts_menu:not(.inited):not(.sc_layouts_menu_dir_vertical.sc_layouts_submenu_dropdown) > ul:not(.inited)');
		trx_addons_init_sfmenu('.sc_layouts_menu:not(.inited):not(.sc_layouts_submenu_dropdown) > ul:not(.inited)');

		// Check if menu need collapse (before menu showed)
		trx_addons_menu_collapse();

		// Show menu		
		jQuery('.sc_layouts_menu:not(.inited)').each(function() {
			if (jQuery(this).find('>ul.inited').length == 1) jQuery(this).addClass('inited');
		});
	
		// Slide effect for menu
		jQuery('.menu_hover_slide_line:not(.slide_inited),.menu_hover_slide_box:not(.slide_inited)').each(function() {
			var menu = jQuery(this).addClass('slide_inited');
			var style = menu.hasClass('menu_hover_slide_line') ? 'line' : 'box';
			setTimeout(function() {
				if (jQuery.fn.spasticNav !== undefined) {
					menu.find('>ul').spasticNav({
						style: style,
						//color: '',
						colorOverride: false
					});
				}
			}, 500);
		});
	
		// Burger with popup
		jQuery('.sc_layouts_menu_mobile_button_burger:not(.inited)').each(function() {
			var burger = jQuery(this);
			var popup = burger.find('.sc_layouts_menu_popup');
			if (popup.length == 1) {
				burger.addClass('inited').on('click', '>a', function(e) {
					popup.toggleClass('opened').slideToggle();
					e.preventDefault();
					return false;
				});
				popup.on('click', 'a', function(e) {
					var $item = jQuery(this);
					if ( $item.next().hasClass('sub-menu') ) {
						$item.parent().siblings().find( '>.sub-menu' ).fadeOut();
						$item.next().fadeToggle();
						e.preventDefault();
						return false;
					}
				});
				$document.on('click', function(e) {
					jQuery('.sc_layouts_menu_popup.opened').removeClass('opened').slideUp();
				});
			}
		});

		// Keyboard navigation in the menus
		jQuery( '.sc_layouts_menu:not(.inited_kbd)'						// Old menu
			+ ',.menu_mobile_nav_area:not(.inited_kbd)'					// Old mobile menu
			+ ',.trx-addons-nav-menu-container:not(.inited_kbd)'		// New menu
			+ ',.trx-addons-mobile-menu-container:not(.inited_kbd)'		// New mobile menu
			)
			.addClass( 'inited_kbd' )
			.on( 'keydown', 'li > a', function(e) {
				var handled = false,
					link = jQuery( this ),
					li = link.parent(),
					ul = li.parent(),
					li_parent = ul.parent().prop( 'tagName' ) == 'LI' ? ul.parent() : false,
					item = false,
					is_new_menu = li.hasClass( 'trx-addons-nav-menu-item' ),
					is_mobile_menu = li.closest( '.inited_kbd' ).hasClass( 'trx-addons-mobile-menu-container' ) || li.closest( '.inited_kbd' ).hasClass( 'menu_mobile_nav_area' );
				if ( 32 == e.which ) {								// Space
					link.trigger( 'click' );
					handled = true;
				} else if ( 27 == e.which ) {						// Esc
					if ( li_parent ) {
						if ( is_new_menu ) {
							li.trigger( 'mouseleave' );
							ul.trigger( 'mouseleave' );
						}
						item = li_parent.find( '> a' );
						if ( item.length > 0 ) {
							if ( is_new_menu ) {
								li_parent.trigger( 'mouseenter' );
							}
							item.get(0).focus();
						}
					}
					handled = true;
				} else if ( 37 == e.which ) {						// Left
					if ( li_parent ) {
						item = li_parent.find( '> a' );
						if ( item.length > 0 ) {
							if ( is_mobile_menu ) {
								item.find( '> .open_child_menu,> .trx-addons-menu-link-text > .trx-addons-dropdown-icon' ).trigger( 'click' );
							}
							if ( is_new_menu ) {
								li.trigger( 'mouseleave' );
								li_parent.trigger( 'mouseenter' );
							}
							item.get(0).focus();
						}
					} else if ( li.index() > 0 ) {
						item = li.prev().find( '> a' );
						if ( item.length > 0 ) {
							if ( is_new_menu ) {
								li.trigger( 'mouseleave' );
								item.closest( 'li' ).trigger( 'mouseenter' );
							}
							item.eq(0).focus();
						}
					}
					handled = true;
				} else if ( 38 == e.which ) {						// Top
					if ( li.index() > 0 ) {
						item = li.prev().find( '> a' );
						if ( item.length > 0 ) {
							if ( is_new_menu ) {
								li.trigger( 'mouseleave' );
								item.closest( 'li' ).trigger( 'mouseenter' );
							}
							item.get(0).focus();
						}
					} else if ( li_parent ) {
						item = li_parent.find( '> a' );
						if ( item.length > 0 ) {
							if ( is_new_menu ) {
								li.trigger( 'mouseleave' );
								li_parent.trigger( 'mouseenter' );
							}
							item.get(0).focus();
						}
					}
					handled = true;
				} else if ( 39 == e.which ) {						// Right
					if ( li_parent ) {
						if ( li.find( '> ul' ).length == 1 ) {
							if ( is_mobile_menu ) {
								li.find( 'a > .open_child_menu,> a > .trx-addons-menu-link-text > .trx-addons-dropdown-icon' ).trigger( 'click' );
							}
							item = li.find( '> ul > li:first-child a' );
							if ( item.length > 0 ) {
								if ( is_new_menu ) {
									li.trigger( 'mouseleave' );
									item.closest( 'li' ).trigger( 'mouseenter' );
								}
								item.get(0).focus();
							}
						}
					} else if ( is_mobile_menu && li.find( '> ul' ).length == 1 ) {
						li.find( '> a > .open_child_menu,> a > .trx-addons-menu-link-text > .trx-addons-dropdown-icon' ).trigger( 'click' );
					} else if ( li.next().prop( 'tagName' ) == 'LI' ) {
						item = li.next().find( '> a' );
						if ( item.length > 0 ) {
							if ( is_new_menu ) {
								li.trigger( 'mouseleave' );
								item.closest( 'li' ).trigger( 'mouseenter' );
							}
							item.get(0).focus();
						}
					}
					handled = true;
				} else if ( 40 == e.which ) {						// Bottom
					if ( li_parent || li.find( '> ul' ).length === 0 || ( is_mobile_menu && ! li.hasClass( 'trx-addons-active-menu' ) && ! li.hasClass( 'opened' ) && li.next().prop( 'tagName' ) == 'LI' ) ) {
						if ( li.next().prop( 'tagName' ) == 'LI' ) {
							item = li.next().find( '> a' );
							if ( item.length > 0 ) {
								if ( is_new_menu ) {
									li.trigger( 'mouseleave' );
									item.closest( 'li' ).trigger( 'mouseenter' );
								}
								item.get(0).focus();
							}
						}
					} else if ( li.find( '> ul' ).length == 1 ) {
						item = li.find( '> ul > li:first-child a' );
						if ( item.length > 0 ) {
							if ( is_new_menu ) {
								li.trigger( 'mouseleave' );
								item.closest( 'li' ).trigger( 'mouseenter' );
							}
							item.get(0).focus();
						}
					}
					handled = true;
				}
				if ( handled ) {
					var $body = jQuery('body');
					if ( ! $body.hasClass( 'show_outline' ) ) {
						$body.addClass( 'show_outline' );
					}
					e.preventDefault();
					return false;
				}
				return true;
			} );
	});
	

	// Collapse menu on resize
	$document.on('action.resize_trx_addons', function() {
		trx_addons_menu_collapse();
	});
	
	// Collapse menu items
	function trx_addons_menu_collapse() {
		if ( TRX_ADDONS_STORAGE['menu_collapse'] == 0 ) {
			return;
		}
		jQuery('.sc_layouts_menu:not(.sc_layouts_menu_no_collapse):not(.sc_layouts_menu_dir_vertical),.elementor-widget-trx_elm_nav_menu.trx-addons-nav-hor .trx-addons-nav-menu-container-collapse').each( function() {
			var nav = jQuery( this );
			if ( nav.parents('div:hidden,section:hidden,article:hidden').length > 0 ) {
				return;
			}
			var ul = nav.find( '>ul:not(.sc_layouts_menu_no_collapse).inited,>ul.trx-addons-nav-menu' );
			if ( ul.length === 0 ) {		//|| ul.find('> li').length < 2
				return;
			}
			var li_collapse_new = ul.hasClass( 'trx-addons-nav-menu' );
			var li_collapse_class = li_collapse_new ? 'trx-addons-nav-menu-collapse'  : 'menu-collapse';
			var li_collapse_classes = [ 'menu-item', li_collapse_class ];
			if ( li_collapse_new ) {
				li_collapse_classes.push( 'menu-item-type-custom' );
				li_collapse_classes.push( 'menu-item-object-custom' );
				li_collapse_classes.push( 'menu-item-has-children' );
				li_collapse_classes.push( 'trx-addons-nav-menu-item' );
			}

			// Check if an item is a one of supported menu wrappers
			function check_menu_wrapper( item ) {
				var allow_any_wrapper = trx_addons_apply_filters( 'trx_addons_filter_menu_collapse_allow_any_wrapper', true );
				var rez = allow_any_wrapper;
				// Check for supported wrapper
				if ( ! allow_any_wrapper ) {
					var wrappers_list = trx_addons_apply_filters(
											'trx_addons_filter_menu_collapse_wrapper_classes',
											[
												'sc_layouts_column',		// Hardcoded column
												'wpb_wrapper',				// VC column
												'elementor-widget-wrap',	// Elementor widget wrapper
												'e-con',					// Elementor container
												'e-con-inner',				// Elementor container inner
												'wp-block-column',			// Gutenberg column
												'kt-inside-inner-col'		// Kadence blocks column
											]
										);
					for (var i = 0; i < wrappers_list.length; i++ ){
						if ( item.hasClass( wrappers_list[i] ) ) {
							rez = true;
							break;
						}
					}
				}
				return rez;
			}
			// Check if an item is a one of allowed delimiters
			function check_item_delimiter( item ) {
				var delimiters_list = trx_addons_apply_filters(
											'trx_addons_filter_menu_collapse_delimiter_classes',
											[
												'vc_empty_space',					// VC Spacer
												'vc_separator',						// VC Separator
												'elementor-widget-spacer',			// Elementor Spacer
												'elementor-widget-divider',			// Elementor Divider
												'wp-block-spacer',					// Gutenberg Spacer
												'wp-block-separator',				// Gutenberg Separator
												'wp-block-kadence-spacer',			// Kadence Spacer
												'wp-block-coblocks-shape-divider'	// CoBlocks Divider
											]
										);
				var rez = false;
				for (var i = 0; i < delimiters_list.length; i++ ){
					if ( item.hasClass( delimiters_list[i] ) ) {
						rez = true;
						break;
					}
				}
				return rez;
			}
			var sc_layouts_item_wrapper = nav.parents('.sc_layouts_item,.elementor-element').eq(0),
				sc_layouts_item = sc_layouts_item_wrapper.length > 0 ? sc_layouts_item_wrapper : nav,
				sc_layouts_item_parent = sc_layouts_item.parent();
			if ( ! check_menu_wrapper( sc_layouts_item_parent ) ) {
				return;
			}
			// Calculate max free space for menu
			var w_max = sc_layouts_item_parent.width()
						- ( Math.ceil( parseFloat( sc_layouts_item.css('marginLeft') ) ) + Math.ceil( parseFloat( sc_layouts_item.css('marginRight') ) ) )
						- 2;	// Leave additional 2px empty
			var w_siblings = 0,
				in_group = 0,
				ul_id = ul.attr('id'),
				gap = sc_layouts_item_parent.css('gap') || '0';
			gap = gap.split(' ');
			gap = gap.length > 1 ? parseFloat( gap[1] ) : parseFloat( gap[0] );
			if ( isNaN(gap) || gap < 0 ) {
				gap = 0;
			}
			sc_layouts_item_parent.find( '>div' + ( sc_layouts_item_parent.attr( 'class' ).indexOf( 'elementor-' ) >= 0 || sc_layouts_item_parent.attr( 'class' ).indexOf( 'e-con' ) >= 0 ? '.elementor-element' : '' ) ).each( function() {
				if ( in_group > 1 ) {
					return;
				}
				var $self = jQuery(this);
				if ( check_item_delimiter( $self ) ) {
					if ( in_group == 1 ) {
						in_group = 2;
					} else {
						w_siblings = 0;
					}
				} else {
					if ( $self.find( '#' + ul_id ).length > 0 ) {
						in_group = 1;
					} else {
						w_siblings += ( $self.outerWidth() + Math.ceil(parseFloat( $self.css('marginLeft') ) ) + Math.ceil( parseFloat( $self.css('marginRight') ) ) ) + gap;
					}
				}
			});
			w_max -= w_siblings;
			// Add collapse item if not exists
			var w_all = 0;
			var move = false;
			var li_collapse = ul.find( '> li.' + li_collapse_classes.join('.') );
			if ( li_collapse.length === 0 ) {
				var li_collapse_text = nav.data( 'collapse-text' ) || '';
				var li_collapse_icon = nav.data( 'collapse-icon' ) || TRX_ADDONS_STORAGE['menu_collapse_icon'];
				if ( ! li_collapse_icon || li_collapse_icon == 'none' ) {
					li_collapse_icon = nav.data( 'collapse-menu-icon' );
				}
				var li_collapse_icon_class = li_collapse_icon && li_collapse_icon.indexOf( '<' ) == -1 ?  ' ' + li_collapse_icon : '';
				ul.append( '<li class="' + li_collapse_classes.join( ' ' ) + '">'
								+ '<a href="#" class="' + ( li_collapse_new ? 'trx-addons-menu-link trx-addons-menu-link-parent' : 'sf-with-ul' ) + li_collapse_icon_class + '">'
									+ ( li_collapse_new
										? '<span class="trx-addons-menu-link-text">'
												+ ( li_collapse_text
													? '<span class="trx-addons-menu-link-text-inner">' + li_collapse_text + '</span>'
													: ''
													)
												+ ( li_collapse_icon && ! li_collapse_icon_class
													? '<span class="trx-addons-dropdown-icon trx-addons-icon">' + li_collapse_icon + '</span>'
													: ''
													)
											+ '</span>'
										: ''
										)
								+ '</a>'
								+ '<ul class="' + ( li_collapse_new ? 'trx-addons-submenu' : 'submenu' ) + '"></ul>'
							+ '</li>'
						);
				li_collapse = ul.find( '> li.' + li_collapse_classes.join('.') );
			}
			var li_collapse_ul = li_collapse.find('> ul');
			// Check if need to move items
			ul.find('> li').each( function( idx ) {
				var cur_item = jQuery( this );
				cur_item.data( 'index', idx );
				if ( move || cur_item.attr('id') == 'blob' ) {
					return;
				}
				var cur_item_width = ! cur_item.hasClass( li_collapse_class ) || cur_item.css('display') != 'none' 
										? cur_item.outerWidth()
											+ Math.ceil( parseFloat( cur_item.css( 'marginLeft' ) ) )
											+ Math.ceil( parseFloat( cur_item.css( 'marginRight' ) ) )
										: 0;
				w_all += cur_item_width;
				if ( w_all > w_max ) {
					move = true;
				}
			} );

			// If need to move items to the collapsed item
			if ( move ) {
				// Display collapse item to calculate its width
				li_collapse.show();
				w_all = li_collapse.outerWidth()
							+ Math.ceil( parseFloat( li_collapse.css( 'marginLeft' ) ) )
							+ Math.ceil( parseFloat( li_collapse.css( 'marginRight' ) ) );
				var items = ul.find( "> li:not('." + li_collapse_class + "'):not(#blob)" ),
					visible = nav.data( 'collapse-visible' ) || 0,
					cnt_visible = 0;
				items.each( function( idx ) {
					var cur_item = jQuery( this );
					var cur_width = cur_item.outerWidth()
										+ Math.ceil( parseFloat( cur_item.css( 'marginLeft' ) ) )
										+ Math.ceil( parseFloat( cur_item.css( 'marginRight' ) ) );
					if ( w_all <= w_max ) {
						w_all += cur_width;
					}
					if ( w_all > w_max && cnt_visible >= visible ) {
						cur_item
							.attr( 'class', cur_item.attr( 'class' ).replace( 'trx_addons_stretch_', 'trx_addons_nostretch_' ) )
							.find( '> ul' )
								.attr( 'style', '' );
						if ( li_collapse_new ) {
							cur_item.addClass( 'trx-addons-submenu-item' )
								.find( '> a' ).addClass( 'trx-addons-submenu-link' )
									.find( '> .trx-addons-menu-link-text' ).addClass( 'trx-addons-submenu-link-text' )
										.find( '> .trx-addons-dropdown-icon' ).html( nav.data( 'collapse-submenu-icon' ) );
						}
						var moved = false;
						li_collapse_ul.find( '>li' ).each( function() {
							if ( ! moved && Number( jQuery( this ).data( 'index' ) ) > idx ) {
								cur_item
									.attr( 'data-width', cur_width )
									.insertBefore( jQuery( this ) );
								moved = true;
							}
						} );
						if ( ! moved ) {
							cur_item
								.attr( 'data-width', cur_width )
								.appendTo( li_collapse_ul );
						}
					} else {
						cnt_visible++;
					}
				} );
				$document.trigger( 'action.menu-collapse-items-moved', ['collapse'] );
						
			// Else - move items to the menu again
			} else {

				var items = li_collapse_ul.find( '>li' );
				var cnt = 0;
				move = true;
				//w_all += 20; 	// Leave 20px empty
				items.each( function() {
					if ( ! move ) {
						return;
					}
					if ( items.length - cnt == 1 ) {
						w_all -= ( li_collapse.outerWidth()
									+ Math.ceil( parseFloat( li_collapse.css( 'marginLeft' ) ) )
									+ Math.ceil( parseFloat( li_collapse.css( 'marginRight' ) ) )
									);
					}
					var $item = jQuery( this );
					w_all += parseFloat( $item.data( 'width' ) );
					if ( w_all < w_max ) {
						if ( li_collapse_new ) {
							$item.removeClass( 'trx-addons-submenu-item' )
								.find( '> a' ).removeClass( 'trx-addons-submenu-link' )
									.find( '> .trx-addons-menu-link-text' ).removeClass( 'trx-addons-submenu-link-text' )
										.find( '> .trx-addons-dropdown-icon' ).html( nav.data( 'collapse-menu-icon' ) );
						}
						$item
							.attr( 'class', $item.attr( 'class' ).replace( 'trx_addons_nostretch_', 'trx_addons_stretch_' ) )
							.insertBefore( li_collapse );
						cnt++;
					} else {
						move = false;
					}
				} );
				if ( items.length - cnt === 0 ) {
					li_collapse.hide();
				}
				if ( cnt ) {
					$document.trigger( 'action.menu-collapse-items-moved', ['expand'] );
				}
			}
		} );
	}

	// Stretch submenu with layouts
	window.trx_addons_stretch_submenu = function(menu_item) {
		var done = false;
		if ( ! menu_item.length ) {
			return done;
		}
		var parent_class = menu_item.parent().attr('class');
		if ( TRX_ADDONS_STORAGE['menu_stretch'] == 1
			&& ! menu_item.hasClass('trx_addons_no_stretch')
			&& parent_class.indexOf('trx_addons_no_stretch') == -1
			&& ! menu_item.parents('.sc_layouts_menu').hasClass('sc_layouts_menu_dir_vertical')
			&& trx_addons_apply_filters( 'trx_addons_filter_stretch_menu',
											menu_item.hasClass('sc_layouts_submenu')
												// || menu_item.hasClass('trx-addons-mega-content-container')	// Allow to stretch a NavMenu mega menu by default
												|| parent_class.indexOf('columns-') != -1
												|| parent_class.indexOf('trx_addons_stretch_') != -1,
											menu_item
										)
		) {
			var menu = menu_item.parents("ul");
			if ( menu.length == 1 ) {
				var $body = jQuery('body'),
					li = menu_item.parents("li").eq(0),
					stretch_to = trx_addons_apply_filters( 'trx_addons_filter_stretch_menu_to',
									li.hasClass( 'trx_addons_stretch_window' )
										? 'window'
										: ( li.hasClass( 'trx_addons_stretch_window_boxed' )
											? 'window_boxed'
											: 'content'
											),
									menu_item
								),
					content_wrap_selector = trx_addons_apply_filters( 'trx_addons_filter_stretch_menu_content_wrap_selector', '.content_wrap', menu_item ),
					content_wrap = jQuery( content_wrap_selector ).eq(0);
				if ( ! content_wrap.length ) {
					$body.append( trx_addons_apply_filters( 'trx_addons_filter_stretch_menu_content_wrap_html',
									'<div class="content_wrap" style="height:0;visibility:hidden;"></div>',
									menu_item
								) );
					content_wrap = jQuery( content_wrap_selector ).eq(0);
					if ( ! content_wrap.length ) {
						content_wrap = trx_addons_apply_filters( 'trx_addons_filter_stretch_menu_content_wrap', content_wrap, menu_item );
					}
				}
				if ( content_wrap.length == 1 ) {
					// Find a first parent with the style 'position: relative' (if li is not relative)
					if ( li.css('position') != 'relative' ) {
						var par = li.parents().filter( function() {
							return jQuery(this).css('position') == 'relative';
						} ).eq(0);
						if ( par.length > 0 ) {
							li = par;
						}
					}
					var bw = $body.innerWidth(),
						cw = trx_addons_apply_filters( 'trx_addons_filter_stretch_menu_content_wrap_width', content_wrap.innerWidth(), menu_item, content_wrap ),
						cw_offset = content_wrap.offset().left,
						li_offset = li.offset().left;
					menu_item
						.css( {
							'width': ( stretch_to == 'window' ? bw : cw ) + 'px',
							'max-width': 'none',
							'left': -li_offset + ( stretch_to == 'window' ? 0 : cw_offset ) + 'px',
							'right': 'auto',
							'transform': 'none'
						} );
					if ( stretch_to == 'window' ) {
						menu_item
							.data( 'reset-style', '.elementor-section-boxed > .elementor-container,.e-con-boxed > .e-con-inner' )
							.find( '.elementor-section-boxed > .elementor-container,.e-con-boxed > .e-con-inner' ).css( {'max-width': 'none' } );
					} else if ( stretch_to == 'window_boxed' ) {
						var bg = menu_item.find('> .sc_layouts_menu_stretch_bg');
						if ( bg.length === 0 ) {
							menu_item.append( '<span class="sc_layouts_menu_stretch_bg"></span>' );
							bg = menu_item.find('> .sc_layouts_menu_stretch_bg');
							bg.css( {
								'background-color': menu_item.css('background-color')
							} );
						}
						bg.css( {
							'left': -(cw_offset + 1) + 'px',
							'right': -(bw - cw_offset - cw + 1) + 'px'
						} );
					}
					done = true;
					$document.trigger('action.resize_trx_addons', [menu_item] );
				}
			}
		}
		return done;
	};


	window.trx_addons_shift_submenu = function(menu_item) {
		var window_width = jQuery(window).width(),
			page_wrap = jQuery(trx_addons_apply_filters( 'trx_addons_filter_page_wrap_class', TRX_ADDONS_STORAGE['page_wrap_class'] ? TRX_ADDONS_STORAGE['page_wrap_class'] : '.page_wrap', 'menu-before-show' )).eq(0),
			page_wrap_width = page_wrap.length > 0 ? page_wrap.width() : window_width,
			page_wrap_offset = page_wrap.length > 0 ? page_wrap.offset().left : 0,
			par = menu_item.parents("ul").eq(0),
			par_offset = par.length > 0 ? par.offset().left : 0,
			par_width  = par.length > 0 ? par.outerWidth() : 0,
			ul_width   = menu_item.outerWidth(),
			rtl = jQuery( 'body' ).hasClass( 'rtl' );

		// Detect horizontal position (left | right)
		if ( menu_item.parents("ul").length > 1 ) {
			if ( ( ! rtl && (
							( par_offset + par_width + ul_width > page_wrap_offset + page_wrap_width - 10 && par_offset - ul_width > page_wrap_offset )
							||
							( par_offset + par_width + ul_width > window_width && par_offset - ul_width > 0 )
							)
					)
				||
				( rtl && (
							( par_offset - ul_width < page_wrap_offset + 10 && par_offset + par_width + ul_width < page_wrap_offset + page_wrap_width )
							||
							( par_offset - ul_width < 0 && par_offset + par_width + ul_width < window_width )
						)
					)
			) {
				menu_item.addClass('submenu_left');
			} else {
				menu_item.removeClass('submenu_left');
			}
		}

		// Shift submenu in the main menu (if submenu is going out of the window)
		if (menu_item.parents( TRX_ADDONS_STORAGE['header_wrap_class'] ).length > 0) {
			// Stretch submenu
			var wide = trx_addons_stretch_submenu(menu_item);

			// Shift horizontal
			if ( ! wide ) {
				var ul_pos = menu_item.data('ul_pos'),
					// submenu_left = menu_item.hasClass('submenu_left');
					submenu_left = ( menu_item.hasClass('submenu_left') && ! rtl ) || ( ! menu_item.hasClass('submenu_left') && rtl ),
					submenu_centered = menu_item.parent().css( 'position' ).indexOf( 'static' ) >= 0;
				if ( ul_pos === undefined && ! submenu_centered ) {
					ul_pos = parseFloat( menu_item.css( submenu_left ? 'right' : 'left' ) );
				}
				if ( isNaN(ul_pos) ) {
					ul_pos = 0;
				}
				var ul_offset = menu_item.parents("ul").length > 1
									? par_offset + ul_pos	// menu_item.offset().left
									: ( submenu_centered
										? par_offset + par_width / 2 - ul_width / 2
										: menu_item.parent().offset().left
										);
				if ( submenu_left ) {
					if (ul_offset < 0) {
						if (menu_item.data('ul_pos') == undefined) {
							menu_item.data('ul_pos', ul_pos);
						}
						menu_item.css( {
							'right': ul_pos + ul_offset + 'px',
							'left': 'auto',
							'transform': 'none'
						} );
					}
				} else {
					if (ul_offset + ul_width >= window_width) {
						if (menu_item.data('ul_pos') == undefined) {
							menu_item.data('ul_pos', ul_pos);
						}
						menu_item.css( {
							'left': ( ( submenu_centered ? par_width / 2 : ul_pos ) - ( ul_offset + ul_width - window_width ) ) + 'px',
						} );
					} else if (ul_offset < 0) {
						if (menu_item.data('ul_pos') == undefined) {
							menu_item.data('ul_pos', ul_pos);
						}
						menu_item.css( {
							'left': submenu_centered ? par_width / 2 - ul_offset : 0
						} );
					}
				}

				// Shift vertical
				var ul_height = menu_item.outerHeight(),
					w_height = jQuery(window).height(),
					menu = menu_item.parents('.sc_layouts_menu').eq(0),
					row_offset = menu.length ? menu.offset().top - jQuery(window).scrollTop() : 0,
					row_height = 0,
					par_top = 0;
				par = menu_item.parent();
				par_offset = 0;
				while ( par.length > 0 ) {
					par_top = par.position().top;
					par_offset += par_top + par.parent().position().top;
					row_height = par.outerHeight();
					if (par_top === 0) break;
					par = par.parents('li').eq(0);
				}
				if (row_offset + par_offset + ul_height > w_height) {
					if (par_offset > ul_height) {
						menu_item.css( {
							'top': 'auto',
							'bottom': '-' + ( menu_item.css('padding-bottom') || 0 )
						} );
					} else {
						menu_item.css( {
							'top': '-' + ( par_offset - row_height - 2 ) + 'px',
							'bottom': 'auto'
						} );
					}
				}
			}
		}
	};

} )();