<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0
 */

							do_action( 'cerebrum_action_page_content_end_text' );
							
							// Widgets area below the content
							cerebrum_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'cerebrum_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'cerebrum_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'cerebrum_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'cerebrum_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$cerebrum_body_style = cerebrum_get_theme_option( 'body_style' );
					$cerebrum_widgets_name = cerebrum_get_theme_option( 'widgets_below_page', 'hide' );
					$cerebrum_show_widgets = ! cerebrum_is_off( $cerebrum_widgets_name ) && is_active_sidebar( $cerebrum_widgets_name );
					$cerebrum_show_related = cerebrum_is_single() && cerebrum_get_theme_option( 'related_position', 'below_content' ) == 'below_page';
					if ( $cerebrum_show_widgets || $cerebrum_show_related ) {
						if ( 'fullscreen' != $cerebrum_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $cerebrum_show_related ) {
							do_action( 'cerebrum_action_related_posts' );
						}

						// Widgets area below page content
						if ( $cerebrum_show_widgets ) {
							cerebrum_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $cerebrum_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'cerebrum_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'cerebrum_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! cerebrum_is_singular( 'post' ) && ! cerebrum_is_singular( 'attachment' ) ) || ! in_array ( cerebrum_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<span id="footer_skip_link_anchor" class="cerebrum_skip_link_anchor"></span>
				<?php

				do_action( 'cerebrum_action_before_footer' );

				// Footer
				$cerebrum_footer_type = cerebrum_get_theme_option( 'footer_type' );
				if ( 'custom' == $cerebrum_footer_type && ! cerebrum_is_layouts_available() ) {
					$cerebrum_footer_type = 'default';
				}
				get_template_part( apply_filters( 'cerebrum_filter_get_template_part', "templates/footer-" . sanitize_file_name( $cerebrum_footer_type ) ) );

				do_action( 'cerebrum_action_after_footer' );

			}
			?>

			<?php do_action( 'cerebrum_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'cerebrum_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'cerebrum_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>