<div class="front_page_section front_page_section_about<?php
	$cerebrum_scheme = cerebrum_get_theme_option( 'front_page_about_scheme' );
	if ( ! empty( $cerebrum_scheme ) && ! cerebrum_is_inherit( $cerebrum_scheme ) ) {
		echo ' scheme_' . esc_attr( $cerebrum_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( cerebrum_get_theme_option( 'front_page_about_paddings' ) );
	if ( cerebrum_get_theme_option( 'front_page_about_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$cerebrum_css      = '';
		$cerebrum_bg_image = cerebrum_get_theme_option( 'front_page_about_bg_image' );
		if ( ! empty( $cerebrum_bg_image ) ) {
			$cerebrum_css .= 'background-image: url(' . esc_url( cerebrum_get_attachment_url( $cerebrum_bg_image ) ) . ');';
		}
		if ( ! empty( $cerebrum_css ) ) {
			echo ' style="' . esc_attr( $cerebrum_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$cerebrum_anchor_icon = cerebrum_get_theme_option( 'front_page_about_anchor_icon' );
	$cerebrum_anchor_text = cerebrum_get_theme_option( 'front_page_about_anchor_text' );
if ( ( ! empty( $cerebrum_anchor_icon ) || ! empty( $cerebrum_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_about"'
									. ( ! empty( $cerebrum_anchor_icon ) ? ' icon="' . esc_attr( $cerebrum_anchor_icon ) . '"' : '' )
									. ( ! empty( $cerebrum_anchor_text ) ? ' title="' . esc_attr( $cerebrum_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_about_inner
	<?php
	if ( cerebrum_get_theme_option( 'front_page_about_fullheight' ) ) {
		echo ' cerebrum-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$cerebrum_css           = '';
			$cerebrum_bg_mask       = cerebrum_get_theme_option( 'front_page_about_bg_mask' );
			$cerebrum_bg_color_type = cerebrum_get_theme_option( 'front_page_about_bg_color_type' );
			if ( 'custom' == $cerebrum_bg_color_type ) {
				$cerebrum_bg_color = cerebrum_get_theme_option( 'front_page_about_bg_color' );
			} elseif ( 'scheme_bg_color' == $cerebrum_bg_color_type ) {
				$cerebrum_bg_color = cerebrum_get_scheme_color( 'bg_color', $cerebrum_scheme );
			} else {
				$cerebrum_bg_color = '';
			}
			if ( ! empty( $cerebrum_bg_color ) && $cerebrum_bg_mask > 0 ) {
				$cerebrum_css .= 'background-color: ' . esc_attr(
					1 == $cerebrum_bg_mask ? $cerebrum_bg_color : cerebrum_hex2rgba( $cerebrum_bg_color, $cerebrum_bg_mask )
				) . ';';
			}
			if ( ! empty( $cerebrum_css ) ) {
				echo ' style="' . esc_attr( $cerebrum_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_about_content_wrap content_wrap">
			<?php
			// Caption
			$cerebrum_caption = cerebrum_get_theme_option( 'front_page_about_caption' );
			if ( ! empty( $cerebrum_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_about_caption front_page_block_<?php echo ! empty( $cerebrum_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $cerebrum_caption, 'cerebrum_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$cerebrum_description = cerebrum_get_theme_option( 'front_page_about_description' );
			if ( ! empty( $cerebrum_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_about_description front_page_block_<?php echo ! empty( $cerebrum_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $cerebrum_description ), 'cerebrum_kses_content' ); ?></div>
				<?php
			}

			// Content
			$cerebrum_content = cerebrum_get_theme_option( 'front_page_about_content' );
			if ( ! empty( $cerebrum_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_content front_page_section_about_content front_page_block_<?php echo ! empty( $cerebrum_content ) ? 'filled' : 'empty'; ?>">
					<?php
					$cerebrum_page_content_mask = '%%CONTENT%%';
					if ( strpos( $cerebrum_content, $cerebrum_page_content_mask ) !== false ) {
						$cerebrum_content = preg_replace(
							'/(\<p\>\s*)?' . $cerebrum_page_content_mask . '(\s*\<\/p\>)/i',
							sprintf(
								'<div class="front_page_section_about_source">%s</div>',
								apply_filters( 'the_content', get_the_content() )
							),
							$cerebrum_content
						);
					}
					cerebrum_show_layout( $cerebrum_content );
					?>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>
