<div class="front_page_section front_page_section_googlemap<?php
	$cerebrum_scheme = cerebrum_get_theme_option( 'front_page_googlemap_scheme' );
	if ( ! empty( $cerebrum_scheme ) && ! cerebrum_is_inherit( $cerebrum_scheme ) ) {
		echo ' scheme_' . esc_attr( $cerebrum_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( cerebrum_get_theme_option( 'front_page_googlemap_paddings' ) );
	if ( cerebrum_get_theme_option( 'front_page_googlemap_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$cerebrum_css      = '';
		$cerebrum_bg_image = cerebrum_get_theme_option( 'front_page_googlemap_bg_image' );
		if ( ! empty( $cerebrum_bg_image ) ) {
			$cerebrum_css .= 'background-image: url(' . esc_url( cerebrum_get_attachment_url( $cerebrum_bg_image ) ) . ');';
		}
		if ( ! empty( $cerebrum_css ) ) {
			echo ' style="' . esc_attr( $cerebrum_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$cerebrum_anchor_icon = cerebrum_get_theme_option( 'front_page_googlemap_anchor_icon' );
	$cerebrum_anchor_text = cerebrum_get_theme_option( 'front_page_googlemap_anchor_text' );
if ( ( ! empty( $cerebrum_anchor_icon ) || ! empty( $cerebrum_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_googlemap"'
									. ( ! empty( $cerebrum_anchor_icon ) ? ' icon="' . esc_attr( $cerebrum_anchor_icon ) . '"' : '' )
									. ( ! empty( $cerebrum_anchor_text ) ? ' title="' . esc_attr( $cerebrum_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_googlemap_inner
		<?php
		$cerebrum_layout = cerebrum_get_theme_option( 'front_page_googlemap_layout' );
		echo ' front_page_section_layout_' . esc_attr( $cerebrum_layout );
		if ( cerebrum_get_theme_option( 'front_page_googlemap_fullheight' ) ) {
			echo ' cerebrum-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
		"
			<?php
			$cerebrum_css      = '';
			$cerebrum_bg_mask  = cerebrum_get_theme_option( 'front_page_googlemap_bg_mask' );
			$cerebrum_bg_color_type = cerebrum_get_theme_option( 'front_page_googlemap_bg_color_type' );
			if ( 'custom' == $cerebrum_bg_color_type ) {
				$cerebrum_bg_color = cerebrum_get_theme_option( 'front_page_googlemap_bg_color' );
			} elseif ( 'scheme_bg_color' == $cerebrum_bg_color_type ) {
				$cerebrum_bg_color = cerebrum_get_scheme_color( 'bg_color', $cerebrum_scheme );
			} else {
				$cerebrum_bg_color = '';
			}
			if ( ! empty( $cerebrum_bg_color ) && $cerebrum_bg_mask > 0 ) {
				$cerebrum_css .= 'background-color: ' . esc_attr(
					1 == $cerebrum_bg_mask ? $cerebrum_bg_color : cerebrum_hex2rgba( $cerebrum_bg_color, $cerebrum_bg_mask )
				) . ';';
			}
			if ( ! empty( $cerebrum_css ) ) {
				echo ' style="' . esc_attr( $cerebrum_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_googlemap_content_wrap
		<?php
		if ( 'fullwidth' != $cerebrum_layout ) {
			echo ' content_wrap';
		}
		?>
		">
			<?php
			// Content wrap with title and description
			$cerebrum_caption     = cerebrum_get_theme_option( 'front_page_googlemap_caption' );
			$cerebrum_description = cerebrum_get_theme_option( 'front_page_googlemap_description' );
			if ( ! empty( $cerebrum_caption ) || ! empty( $cerebrum_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'fullwidth' == $cerebrum_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}
					// Caption
				if ( ! empty( $cerebrum_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_googlemap_caption front_page_block_<?php echo ! empty( $cerebrum_caption ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $cerebrum_caption, 'cerebrum_kses_content' );
					?>
					</h2>
					<?php
				}

					// Description (text)
				if ( ! empty( $cerebrum_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_googlemap_description front_page_block_<?php echo ! empty( $cerebrum_description ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( wpautop( $cerebrum_description ), 'cerebrum_kses_content' );
					?>
					</div>
					<?php
				}
				if ( 'fullwidth' == $cerebrum_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$cerebrum_content = cerebrum_get_theme_option( 'front_page_googlemap_content' );
			if ( ! empty( $cerebrum_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'columns' == $cerebrum_layout ) {
					?>
					<div class="front_page_section_columns front_page_section_googlemap_columns columns_wrap">
						<div class="column-1_3">
					<?php
				} elseif ( 'fullwidth' == $cerebrum_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}

				?>
				<div class="front_page_section_content front_page_section_googlemap_content front_page_block_<?php echo ! empty( $cerebrum_content ) ? 'filled' : 'empty'; ?>">
				<?php
					echo wp_kses( $cerebrum_content, 'cerebrum_kses_content' );
				?>
				</div>
				<?php

				if ( 'columns' == $cerebrum_layout ) {
					?>
					</div><div class="column-2_3">
					<?php
				} elseif ( 'fullwidth' == $cerebrum_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Widgets output
			?>
			<div class="front_page_section_output front_page_section_googlemap_output">
				<?php
				if ( is_active_sidebar( 'front_page_googlemap_widgets' ) ) {
					dynamic_sidebar( 'front_page_googlemap_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! cerebrum_exists_trx_addons() ) {
						cerebrum_customizer_need_trx_addons_message();
					} else {
						cerebrum_customizer_need_widgets_message( 'front_page_googlemap_caption', 'ThemeREX Addons - Google map' );
					}
				}
				?>
			</div>
			<?php

			if ( 'columns' == $cerebrum_layout && ( ! empty( $cerebrum_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>
		</div>
	</div>
</div>
