<?php
$cerebrum_woocommerce_sc = cerebrum_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $cerebrum_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$cerebrum_scheme = cerebrum_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $cerebrum_scheme ) && ! cerebrum_is_inherit( $cerebrum_scheme ) ) {
			echo ' scheme_' . esc_attr( $cerebrum_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( cerebrum_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( cerebrum_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$cerebrum_css      = '';
			$cerebrum_bg_image = cerebrum_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $cerebrum_bg_image ) ) {
				$cerebrum_css .= 'background-image: url(' . esc_url( cerebrum_get_attachment_url( $cerebrum_bg_image ) ) . ');';
			}
			if ( ! empty( $cerebrum_css ) ) {
				echo ' style="' . esc_attr( $cerebrum_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$cerebrum_anchor_icon = cerebrum_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$cerebrum_anchor_text = cerebrum_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $cerebrum_anchor_icon ) || ! empty( $cerebrum_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $cerebrum_anchor_icon ) ? ' icon="' . esc_attr( $cerebrum_anchor_icon ) . '"' : '' )
											. ( ! empty( $cerebrum_anchor_text ) ? ' title="' . esc_attr( $cerebrum_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( cerebrum_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' cerebrum-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$cerebrum_css      = '';
				$cerebrum_bg_mask  = cerebrum_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$cerebrum_bg_color_type = cerebrum_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $cerebrum_bg_color_type ) {
					$cerebrum_bg_color = cerebrum_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $cerebrum_bg_color_type ) {
					$cerebrum_bg_color = cerebrum_get_scheme_color( 'bg_color', $cerebrum_scheme );
				} else {
					$cerebrum_bg_color = '';
				}
				if ( ! empty( $cerebrum_bg_color ) && $cerebrum_bg_mask > 0 ) {
					$cerebrum_css .= 'background-color: ' . esc_attr(
						1 == $cerebrum_bg_mask ? $cerebrum_bg_color : cerebrum_hex2rgba( $cerebrum_bg_color, $cerebrum_bg_mask )
					) . ';';
				}
				if ( ! empty( $cerebrum_css ) ) {
					echo ' style="' . esc_attr( $cerebrum_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$cerebrum_caption     = cerebrum_get_theme_option( 'front_page_woocommerce_caption' );
				$cerebrum_description = cerebrum_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $cerebrum_caption ) || ! empty( $cerebrum_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $cerebrum_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $cerebrum_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $cerebrum_caption, 'cerebrum_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $cerebrum_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $cerebrum_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $cerebrum_description ), 'cerebrum_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $cerebrum_woocommerce_sc ) {
						$cerebrum_woocommerce_sc_ids      = cerebrum_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$cerebrum_woocommerce_sc_per_page = count( explode( ',', $cerebrum_woocommerce_sc_ids ) );
					} else {
						$cerebrum_woocommerce_sc_per_page = max( 1, (int) cerebrum_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$cerebrum_woocommerce_sc_columns = max( 1, min( $cerebrum_woocommerce_sc_per_page, (int) cerebrum_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$cerebrum_woocommerce_sc}"
										. ( 'products' == $cerebrum_woocommerce_sc
												? ' ids="' . esc_attr( $cerebrum_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $cerebrum_woocommerce_sc
												? ' category="' . esc_attr( cerebrum_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $cerebrum_woocommerce_sc
												? ' orderby="' . esc_attr( cerebrum_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( cerebrum_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $cerebrum_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $cerebrum_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
