<?php
/**
 * The Header: Logo and main menu
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( cerebrum_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'cerebrum_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'cerebrum_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('cerebrum_action_body_wrap_attributes'); ?>>

		<?php do_action( 'cerebrum_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'cerebrum_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('cerebrum_action_page_wrap_attributes'); ?>>

			<?php do_action( 'cerebrum_action_page_wrap_start' ); ?>

			<?php
			$cerebrum_full_post_loading = ( cerebrum_is_singular( 'post' ) || cerebrum_is_singular( 'attachment' ) ) && cerebrum_get_value_gp( 'action' ) == 'full_post_loading';
			$cerebrum_prev_post_loading = ( cerebrum_is_singular( 'post' ) || cerebrum_is_singular( 'attachment' ) ) && cerebrum_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $cerebrum_full_post_loading && ! $cerebrum_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="cerebrum_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'cerebrum_filter_skip_links_tabindex', 0 ) ); ?>"><?php esc_html_e( "Skip to content", 'cerebrum' ); ?></a>
				<?php if ( cerebrum_sidebar_present() ) { ?>
				<a class="cerebrum_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'cerebrum_filter_skip_links_tabindex', 0 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'cerebrum' ); ?></a>
				<?php } ?>
				<a class="cerebrum_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'cerebrum_filter_skip_links_tabindex', 0 ) ); ?>"><?php esc_html_e( "Skip to footer", 'cerebrum' ); ?></a>

				<?php
				do_action( 'cerebrum_action_before_header' );

				// Header
				$cerebrum_header_type = cerebrum_get_theme_option( 'header_type' );
				if ( 'custom' == $cerebrum_header_type && ! cerebrum_is_layouts_available() ) {
					$cerebrum_header_type = 'default';
				}
				get_template_part( apply_filters( 'cerebrum_filter_get_template_part', "templates/header-" . sanitize_file_name( $cerebrum_header_type ) ) );

				// Side menu
				if ( in_array( cerebrum_get_theme_option( 'menu_side', 'none' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'cerebrum_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				if ( apply_filters( 'cerebrum_filter_use_navi_mobile', cerebrum_sc_layouts_showed( 'menu_button' ) || $cerebrum_header_type == 'default' ) ) {
					get_template_part( apply_filters( 'cerebrum_filter_get_template_part', 'templates/header-navi-mobile' ) );
				}

				do_action( 'cerebrum_action_after_header' );

			}
			?>

			<?php do_action( 'cerebrum_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( cerebrum_is_off( cerebrum_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $cerebrum_header_type ) ) {
						$cerebrum_header_type = cerebrum_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $cerebrum_header_type && cerebrum_is_layouts_available() ) {
						$cerebrum_header_id = cerebrum_get_custom_header_id();
						if ( $cerebrum_header_id > 0 ) {
							$cerebrum_header_meta = cerebrum_get_custom_layout_meta( $cerebrum_header_id );
							if ( ! empty( $cerebrum_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$cerebrum_footer_type = cerebrum_get_theme_option( 'footer_type' );
					if ( 'custom' == $cerebrum_footer_type && cerebrum_is_layouts_available() ) {
						$cerebrum_footer_id = cerebrum_get_custom_footer_id();
						if ( $cerebrum_footer_id ) {
							$cerebrum_footer_meta = cerebrum_get_custom_layout_meta( $cerebrum_footer_id );
							if ( ! empty( $cerebrum_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'cerebrum_action_page_content_wrap_class', $cerebrum_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'cerebrum_filter_is_prev_post_loading', $cerebrum_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( cerebrum_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'cerebrum_action_page_content_wrap_data', $cerebrum_prev_post_loading );
			?>>
				<?php
				do_action( 'cerebrum_action_page_content_wrap', $cerebrum_full_post_loading || $cerebrum_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'cerebrum_filter_single_post_header', cerebrum_is_singular( 'post' ) || cerebrum_is_singular( 'attachment' ) ) ) {
					if ( $cerebrum_prev_post_loading ) {
						if ( cerebrum_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) != 'article' ) {
							do_action( 'cerebrum_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$cerebrum_path = apply_filters( 'cerebrum_filter_get_template_part', 'templates/single-styles/' . cerebrum_get_theme_option( 'single_style' ) );
					if ( cerebrum_get_file_dir( $cerebrum_path . '.php' ) != '' ) {
						get_template_part( $cerebrum_path );
					}
				}

				// Widgets area above page
				$cerebrum_body_style   = cerebrum_get_theme_option( 'body_style' );
				$cerebrum_widgets_name = cerebrum_get_theme_option( 'widgets_above_page', 'hide' );
				$cerebrum_show_widgets = ! cerebrum_is_off( $cerebrum_widgets_name ) && is_active_sidebar( $cerebrum_widgets_name );
				if ( $cerebrum_show_widgets ) {
					if ( 'fullscreen' != $cerebrum_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					cerebrum_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $cerebrum_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'cerebrum_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $cerebrum_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'cerebrum_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'cerebrum_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<span id="content_skip_link_anchor" class="cerebrum_skip_link_anchor"></span>
						<?php
						// Single posts banner between prev/next posts
						if ( ( cerebrum_is_singular( 'post' ) || cerebrum_is_singular( 'attachment' ) )
							&& $cerebrum_prev_post_loading 
							&& cerebrum_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) == 'article'
						) {
							do_action( 'cerebrum_action_between_posts' );
						}

						// Widgets area above content
						cerebrum_create_widgets_area( 'widgets_above_content' );

						do_action( 'cerebrum_action_page_content_start_text' );
