<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0
 */

$cerebrum_template = apply_filters( 'cerebrum_filter_get_template_part', cerebrum_blog_archive_get_template() );

if ( ! empty( $cerebrum_template ) && 'index' != $cerebrum_template ) {

	get_template_part( $cerebrum_template );

} else {

	cerebrum_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$cerebrum_stickies   = is_home()
								|| ( in_array( cerebrum_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) cerebrum_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$cerebrum_post_type  = cerebrum_get_theme_option( 'post_type' );
		$cerebrum_args       = array(
								'blog_style'     => cerebrum_get_theme_option( 'blog_style' ),
								'post_type'      => $cerebrum_post_type,
								'taxonomy'       => cerebrum_get_post_type_taxonomy( $cerebrum_post_type ),
								'parent_cat'     => cerebrum_get_theme_option( 'parent_cat' ),
								'posts_per_page' => cerebrum_get_theme_option( 'posts_per_page' ),
								'sticky'         => cerebrum_get_theme_option( 'sticky_style', 'inherit' ) == 'columns'
															&& is_array( $cerebrum_stickies )
															&& count( $cerebrum_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		cerebrum_blog_archive_start();

		do_action( 'cerebrum_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'cerebrum_action_before_page_author' );
			get_template_part( apply_filters( 'cerebrum_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'cerebrum_action_after_page_author' );
		}

		if ( cerebrum_get_theme_option( 'show_filters', 0 ) ) {
			do_action( 'cerebrum_action_before_page_filters' );
			cerebrum_show_filters( $cerebrum_args );
			do_action( 'cerebrum_action_after_page_filters' );
		} else {
			do_action( 'cerebrum_action_before_page_posts' );
			cerebrum_show_posts( array_merge( $cerebrum_args, array( 'cat' => $cerebrum_args['parent_cat'] ) ) );
			do_action( 'cerebrum_action_after_page_posts' );
		}

		do_action( 'cerebrum_action_blog_archive_end' );

		cerebrum_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'cerebrum_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'cerebrum_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
