<?php
/* Booked Appointments support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'cerebrum_booked_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'cerebrum_booked_theme_setup9', 9 );
	function cerebrum_booked_theme_setup9() {
		if ( cerebrum_exists_booked() ) {
			add_action( 'wp_enqueue_scripts', 'cerebrum_booked_frontend_scripts', 1100 );
			add_action( 'trx_addons_action_load_scripts_front_booked', 'cerebrum_booked_frontend_scripts', 10, 1 );
			add_action( 'wp_enqueue_scripts', 'cerebrum_booked_frontend_scripts_responsive', 2000 );
			add_action( 'trx_addons_action_load_scripts_front_booked', 'cerebrum_booked_frontend_scripts_responsive', 10, 1 );
			add_filter( 'cerebrum_filter_merge_styles', 'cerebrum_booked_merge_styles' );
			add_filter( 'cerebrum_filter_merge_styles_responsive', 'cerebrum_booked_merge_styles_responsive' );
		}
		if ( is_admin() ) {
			add_filter( 'cerebrum_filter_tgmpa_required_plugins', 'cerebrum_booked_tgmpa_required_plugins' );
			add_filter( 'cerebrum_filter_theme_plugins', 'cerebrum_booked_theme_plugins' );
		}
	}
}


// Filter to add in the required plugins list
if ( ! function_exists( 'cerebrum_booked_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('cerebrum_filter_tgmpa_required_plugins',	'cerebrum_booked_tgmpa_required_plugins');
	function cerebrum_booked_tgmpa_required_plugins( $list = array() ) {
		if ( cerebrum_storage_isset( 'required_plugins', 'booked' ) && cerebrum_storage_get_array( 'required_plugins', 'booked', 'install' ) !== false && cerebrum_is_theme_activated() ) {
			$path = cerebrum_get_plugin_source_path( 'plugins/booked/booked.zip' );
			if ( ! empty( $path ) || cerebrum_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => cerebrum_storage_get_array( 'required_plugins', 'booked', 'title' ),
					'slug'     => 'booked',
					'source'   => ! empty( $path ) ? $path : 'upload://booked.zip',
					'version'  => '2.4.3.1',
					'required' => false,
				);
			}
		}
		return $list;
	}
}


// Filter theme-supported plugins list
if ( ! function_exists( 'cerebrum_booked_theme_plugins' ) ) {
	//Handler of the add_filter( 'cerebrum_filter_theme_plugins', 'cerebrum_booked_theme_plugins' );
	function cerebrum_booked_theme_plugins( $list = array() ) {
		return cerebrum_add_group_and_logo_to_slave( $list, 'booked', 'booked-' );
	}
}


// Check if plugin installed and activated
if ( ! function_exists( 'cerebrum_exists_booked' ) ) {
	function cerebrum_exists_booked() {
		return class_exists( 'booked_plugin' );
	}
}


// Return a relative path to the plugin styles depend the version
if ( ! function_exists( 'cerebrum_booked_get_styles_dir' ) ) {
	function cerebrum_booked_get_styles_dir( $file ) {
		$base_dir = 'plugins/booked/';
		return $base_dir
				. ( defined( 'BOOKED_VERSION' ) && version_compare( BOOKED_VERSION, '2.4', '<' ) && cerebrum_get_folder_dir( $base_dir . 'old' )
					? 'old/'
					: ''
					)
				. $file;
	}
}


// Enqueue styles for frontend
if ( ! function_exists( 'cerebrum_booked_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'cerebrum_booked_frontend_scripts', 1100 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_booked', 'cerebrum_booked_frontend_scripts', 10, 1 );
	function cerebrum_booked_frontend_scripts( $force = false ) {
		cerebrum_enqueue_optimized( 'booked', $force, array(
			'css' => array(
				'cerebrum-booked' => array( 'src' => cerebrum_booked_get_styles_dir( 'booked.css' ) ),
			)
		) );
	}
}


// Enqueue responsive styles for frontend
if ( ! function_exists( 'cerebrum_booked_frontend_scripts_responsive' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'cerebrum_booked_frontend_scripts_responsive', 2000 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_booked', 'cerebrum_booked_frontend_scripts_responsive', 10, 1 );
	function cerebrum_booked_frontend_scripts_responsive( $force = false ) {
		cerebrum_enqueue_optimized_responsive( 'booked', $force, array(
			'css' => array(
				'cerebrum-booked-responsive' => array( 'src' => cerebrum_booked_get_styles_dir( 'booked-responsive.css' ), 'media' => 'all' ),
			)
		) );
	}
}


// Merge custom styles
if ( ! function_exists( 'cerebrum_booked_merge_styles' ) ) {
	//Handler of the add_filter('cerebrum_filter_merge_styles', 'cerebrum_booked_merge_styles');
	function cerebrum_booked_merge_styles( $list ) {
		$list[ cerebrum_booked_get_styles_dir( 'booked.css' ) ] = false;
		return $list;
	}
}


// Merge responsive styles
if ( ! function_exists( 'cerebrum_booked_merge_styles_responsive' ) ) {
	//Handler of the add_filter('cerebrum_filter_merge_styles_responsive', 'cerebrum_booked_merge_styles_responsive');
	function cerebrum_booked_merge_styles_responsive( $list ) {
		$list[ cerebrum_booked_get_styles_dir( 'booked-responsive.css' ) ] = false;
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( cerebrum_exists_booked() ) {
	$cerebrum_fdir = cerebrum_get_file_dir( cerebrum_booked_get_styles_dir( 'booked-style.php' ) );
	if ( ! empty( $cerebrum_fdir ) ) {
		require_once $cerebrum_fdir;
	}
}
