<?php
/* Mail Chimp support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'cerebrum_mailchimp_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'cerebrum_mailchimp_theme_setup9', 9 );
	function cerebrum_mailchimp_theme_setup9() {
		if ( cerebrum_exists_mailchimp() ) {
			add_action( 'wp_enqueue_scripts', 'cerebrum_mailchimp_frontend_scripts', 1100 );
			add_action( 'trx_addons_action_load_scripts_front_mailchimp', 'cerebrum_mailchimp_frontend_scripts', 10, 1 );
			add_filter( 'cerebrum_filter_merge_styles', 'cerebrum_mailchimp_merge_styles' );
		}
		if ( is_admin() ) {
			add_filter( 'cerebrum_filter_tgmpa_required_plugins', 'cerebrum_mailchimp_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'cerebrum_mailchimp_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('cerebrum_filter_tgmpa_required_plugins',	'cerebrum_mailchimp_tgmpa_required_plugins');
	function cerebrum_mailchimp_tgmpa_required_plugins( $list = array() ) {
		if ( cerebrum_storage_isset( 'required_plugins', 'mailchimp-for-wp' ) && cerebrum_storage_get_array( 'required_plugins', 'mailchimp-for-wp', 'install' ) !== false ) {
			$list[] = array(
				'name'     => cerebrum_storage_get_array( 'required_plugins', 'mailchimp-for-wp', 'title' ),
				'slug'     => 'mailchimp-for-wp',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'cerebrum_exists_mailchimp' ) ) {
	function cerebrum_exists_mailchimp() {
		return function_exists( '__mc4wp_load_plugin' ) || defined( 'MC4WP_VERSION' );
	}
}



// Custom styles and scripts
//------------------------------------------------------------------------

// Enqueue styles for frontend
if ( ! function_exists( 'cerebrum_mailchimp_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'cerebrum_mailchimp_frontend_scripts', 1100 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_mailchimp', 'cerebrum_mailchimp_frontend_scripts', 10, 1 );
	function cerebrum_mailchimp_frontend_scripts( $force = false ) {
		cerebrum_enqueue_optimized( 'mailchimp', $force, array(
			'css' => array(
				'cerebrum-mailchimp-for-wp' => array( 'src' => 'plugins/mailchimp-for-wp/mailchimp-for-wp.css' ),
			)
		) );
	}
}

// Merge custom styles
if ( ! function_exists( 'cerebrum_mailchimp_merge_styles' ) ) {
	//Handler of the add_filter( 'cerebrum_filter_merge_styles', 'cerebrum_mailchimp_merge_styles');
	function cerebrum_mailchimp_merge_styles( $list ) {
		$list[ 'plugins/mailchimp-for-wp/mailchimp-for-wp.css' ] = false;
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( cerebrum_exists_mailchimp() ) {
	$cerebrum_fdir = cerebrum_get_file_dir( 'plugins/mailchimp-for-wp/mailchimp-for-wp-style.php' );
	if ( ! empty( $cerebrum_fdir ) ) {
		require_once $cerebrum_fdir;
	}
}

