<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0
 */

if ( cerebrum_sidebar_present() ) {
	
	$cerebrum_sidebar_type = cerebrum_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $cerebrum_sidebar_type && ! cerebrum_is_layouts_available() ) {
		$cerebrum_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $cerebrum_sidebar_type ) {
		// Default sidebar with widgets
		$cerebrum_sidebar_name = cerebrum_get_theme_option( 'sidebar_widgets' );
		cerebrum_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $cerebrum_sidebar_name ) ) {
			dynamic_sidebar( $cerebrum_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$cerebrum_sidebar_id = cerebrum_get_custom_sidebar_id();
		do_action( 'cerebrum_action_show_layout', $cerebrum_sidebar_id );
	}
	$cerebrum_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $cerebrum_out ) ) {
		$cerebrum_sidebar_position    = cerebrum_get_theme_option( 'sidebar_position' );
		$cerebrum_sidebar_position_ss = cerebrum_get_theme_option( 'sidebar_position_ss', 'below' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $cerebrum_sidebar_position );
			echo ' sidebar_' . esc_attr( $cerebrum_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $cerebrum_sidebar_type );

			$cerebrum_sidebar_scheme = apply_filters( 'cerebrum_filter_sidebar_scheme', cerebrum_get_theme_option( 'sidebar_scheme', 'inherit' ) );
			if ( ! empty( $cerebrum_sidebar_scheme ) && ! cerebrum_is_inherit( $cerebrum_sidebar_scheme ) && 'custom' != $cerebrum_sidebar_type ) {
				echo ' scheme_' . esc_attr( $cerebrum_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<span id="sidebar_skip_link_anchor" class="cerebrum_skip_link_anchor"></span>
			<?php

			do_action( 'cerebrum_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $cerebrum_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$cerebrum_title = apply_filters( 'cerebrum_filter_sidebar_control_title', 'float' == $cerebrum_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'cerebrum' ) : '' );
				$cerebrum_text  = apply_filters( 'cerebrum_filter_sidebar_control_text', 'above' == $cerebrum_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'cerebrum' ) : '' );
				?>
				<a href="#" role="button" class="sidebar_control" title="<?php echo esc_attr( $cerebrum_title ); ?>"><?php echo esc_html( $cerebrum_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'cerebrum_action_before_sidebar', 'sidebar' );
				cerebrum_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $cerebrum_out ) );
				do_action( 'cerebrum_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'cerebrum_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
