<?php
/**
 * The template to display single post
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0
 */

// Full post loading
$full_post_loading          = cerebrum_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = cerebrum_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = cerebrum_get_theme_option( 'posts_navigation_scroll_which_block', 'article' );

// Position of the related posts
$cerebrum_related_position   = cerebrum_get_theme_option( 'related_position', 'below_content' );

// Type of the prev/next post navigation
$cerebrum_posts_navigation   = cerebrum_get_theme_option( 'posts_navigation' );
$cerebrum_prev_post          = false;
$cerebrum_prev_post_same_cat = (int)cerebrum_get_theme_option( 'posts_navigation_scroll_same_cat', 1 );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( cerebrum_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	cerebrum_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'cerebrum_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $cerebrum_posts_navigation ) {
		$cerebrum_prev_post = get_previous_post( $cerebrum_prev_post_same_cat );  // Get post from same category
		if ( ! $cerebrum_prev_post && $cerebrum_prev_post_same_cat ) {
			$cerebrum_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $cerebrum_prev_post ) {
			$cerebrum_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $cerebrum_prev_post ) ) {
		cerebrum_sc_layouts_showed( 'featured', false );
		cerebrum_sc_layouts_showed( 'title', false );
		cerebrum_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $cerebrum_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'cerebrum_filter_get_template_part', 'templates/content', 'single-' . cerebrum_get_theme_option( 'single_style' ) ), 'single-' . cerebrum_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $cerebrum_related_position, 'inside' ) === 0 ) {
		$cerebrum_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'cerebrum_action_related_posts' );
		$cerebrum_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $cerebrum_related_content ) ) {
			$cerebrum_related_position_inside = max( 0, min( 9, cerebrum_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $cerebrum_related_position_inside ) {
				$cerebrum_related_position_inside = mt_rand( 1, 9 );
			}

			$cerebrum_p_number         = 0;
			$cerebrum_related_inserted = false;
			$cerebrum_in_block         = false;
			$cerebrum_content_start    = strpos( $cerebrum_content, '<div class="post_content' );
			$cerebrum_content_end      = strrpos( $cerebrum_content, '</div>' );

			for ( $i = max( 0, $cerebrum_content_start ); $i < min( strlen( $cerebrum_content ) - 3, $cerebrum_content_end ); $i++ ) {
				if ( $cerebrum_content[ $i ] != '<' ) {
					continue;
				}
				if ( $cerebrum_in_block ) {
					if ( strtolower( substr( $cerebrum_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$cerebrum_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $cerebrum_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $cerebrum_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$cerebrum_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $cerebrum_content[ $i + 1 ] && in_array( $cerebrum_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$cerebrum_p_number++;
					if ( $cerebrum_related_position_inside == $cerebrum_p_number ) {
						$cerebrum_related_inserted = true;
						$cerebrum_content = ( $i > 0 ? substr( $cerebrum_content, 0, $i ) : '' )
											. $cerebrum_related_content
											. substr( $cerebrum_content, $i );
					}
				}
			}
			if ( ! $cerebrum_related_inserted ) {
				if ( $cerebrum_content_end > 0 ) {
					$cerebrum_content = substr( $cerebrum_content, 0, $cerebrum_content_end ) . $cerebrum_related_content . substr( $cerebrum_content, $cerebrum_content_end );
				} else {
					$cerebrum_content .= $cerebrum_related_content;
				}
			}
		}

		cerebrum_show_layout( $cerebrum_content );
	}

	// Comments
	do_action( 'cerebrum_action_before_comments' );
	comments_template();
	do_action( 'cerebrum_action_after_comments' );

	// Related posts
	if ( 'below_content' == $cerebrum_related_position
		&& ( 'scroll' != $cerebrum_posts_navigation || (int)cerebrum_get_theme_option( 'posts_navigation_scroll_hide_related', 0 ) == 0 )
		&& ( ! $full_post_loading || (int)cerebrum_get_theme_option( 'open_full_post_hide_related', 1 ) == 0 )
	) {
		do_action( 'cerebrum_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $cerebrum_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $cerebrum_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $cerebrum_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $cerebrum_prev_post ) ); ?>"
			data-cur-post-link="<?php echo esc_attr( get_permalink() ); ?>"
			data-cur-post-title="<?php the_title_attribute(); ?>"
			<?php do_action( 'cerebrum_action_nav_links_single_scroll_data', $cerebrum_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
