<?php
/**
 * Required plugins
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
if ( ! function_exists( 'cerebrum_skin_required_plugins' ) ) {
	add_action( 'after_setup_theme', 'cerebrum_skin_required_plugins', -1 );
	/**
	 * Create the list of required plugins for the skin/theme.
	 * Priority -1 is used to create the list of plugins before the rest skin/theme actions.
	 * 
	 * @hooked 'after_setup_theme', -1
	 */
	function cerebrum_skin_required_plugins() {
		$cerebrum_theme_required_plugins_groups = array(
		'core'          => esc_html__( 'Core', 'cerebrum' ),
		'page_builders' => esc_html__( 'Page Builders', 'cerebrum' ),
		'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'cerebrum' ),
		'socials'       => esc_html__( 'Socials and Communities', 'cerebrum' ),
		'events'        => esc_html__( 'Events and Appointments', 'cerebrum' ),
		'content'       => esc_html__( 'Content', 'cerebrum' ),
		'other'         => esc_html__( 'Other', 'cerebrum' ),
		);
		$cerebrum_theme_required_plugins = array(
			'trx_addons'                 => array(
				'title'       => esc_html__( 'ThemeREX Addons', 'cerebrum' ),
				'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'cerebrum' ),
				'required'    => true,
				'logo'        => 'trx_addons.png',
				'group'       => $cerebrum_theme_required_plugins_groups['core'],
			),
			'elementor'                  => array(
				'title'       => esc_html__( 'Elementor', 'cerebrum' ),
				'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'cerebrum' ),
				'required'    => false,
				'logo'        => 'elementor.png',
				'group'       => $cerebrum_theme_required_plugins_groups['page_builders'],
			),
			'gutenberg'                  => array(
				'title'       => esc_html__( 'Gutenberg', 'cerebrum' ),
				'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'cerebrum' ),
				'required'    => false,
				'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'gutenberg.png',
				'group'       => $cerebrum_theme_required_plugins_groups['page_builders'],
			),
			'js_composer'                => array(
				'title'       => esc_html__( 'WPBakery PageBuilder', 'cerebrum' ),
				'description' => esc_html__( "Popular PageBuilder which allows you to create excellent pages", 'cerebrum' ),
				'required'    => false,
				'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'js_composer.jpg',
				'group'       => $cerebrum_theme_required_plugins_groups['page_builders'],
			),
			'woocommerce'                => array(
				'title'       => esc_html__( 'WooCommerce', 'cerebrum' ),
				'description' => esc_html__( "Connect the store to your website and start selling now", 'cerebrum' ),
				'required'    => false,
				'logo'        => 'woocommerce.png',
				'group'       => $cerebrum_theme_required_plugins_groups['ecommerce'],
			),
			'elegro-payment'             => array(
				'title'       => esc_html__( 'Elegro Crypto Payment', 'cerebrum' ),
				'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'cerebrum' ),
				'required'    => false,
				'install'     => false, // TRX_addons has marked the "Elegro Crypto Payment" plugin as obsolete and no longer recommends it for installation, even if it had been previously recommended by the theme
				'logo'        => 'elegro-payment.png',
				'group'       => $cerebrum_theme_required_plugins_groups['ecommerce'],
			),
			'instagram-feed'             => array(
				'title'       => esc_html__( 'Instagram Feed', 'cerebrum' ),
				'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'cerebrum' ),
				'required'    => false,
				'logo'        => 'instagram-feed.png',
				'group'       => $cerebrum_theme_required_plugins_groups['socials'],
			),
			'mailchimp-for-wp'           => array(
				'title'       => esc_html__( 'MailChimp for WP', 'cerebrum' ),
				'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'cerebrum' ),
				'required'    => false,
				'logo'        => 'mailchimp-for-wp.png',
				'group'       => $cerebrum_theme_required_plugins_groups['socials'],
			),
			'booked'                     => array(
				'title'       => esc_html__( 'Booked Appointments', 'cerebrum' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => 'booked.png',
				'group'       => $cerebrum_theme_required_plugins_groups['events'],
			),
			'quickcal'                     => array(
				'title'       => esc_html__( 'QuickCal', 'cerebrum' ),
				'description' => '',
				'required'    => false,
				'logo'        => 'quickcal.png',
				'group'       => $cerebrum_theme_required_plugins_groups['events'],
			),
			'the-events-calendar'        => array(
				'title'       => esc_html__( 'The Events Calendar', 'cerebrum' ),
				'description' => '',
				'required'    => false,
        			'install'     => false,
				'logo'        => 'the-events-calendar.png',
				'group'       => $cerebrum_theme_required_plugins_groups['events'],
			),
			'contact-form-7'             => array(
				'title'       => esc_html__( 'Contact Form 7', 'cerebrum' ),
				'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'cerebrum' ),
				'required'    => false,
				'logo'        => 'contact-form-7.png',
				'group'       => $cerebrum_theme_required_plugins_groups['content'],
			),

			'latepoint'                  => array(
				'title'       => esc_html__( 'LatePoint', 'cerebrum' ),
				'description' => '',
				'required'    => false,
        			'install'     => false,
				'logo'        => cerebrum_get_file_url( 'plugins/latepoint/latepoint.png' ),
				'group'       => $cerebrum_theme_required_plugins_groups['events'],
			),
			'advanced-popups'                  => array(
				'title'       => esc_html__( 'Advanced Popups', 'cerebrum' ),
				'description' => '',
				'required'    => false,
				'logo'        => cerebrum_get_file_url( 'plugins/advanced-popups/advanced-popups.jpg' ),
				'group'       => $cerebrum_theme_required_plugins_groups['content'],
			),
			'devvn-image-hotspot'                  => array(
				'title'       => esc_html__( 'Image Hotspot by DevVN', 'cerebrum' ),
				'description' => '',
				'required'    => false,
        			'install'     => false,
				'logo'        => cerebrum_get_file_url( 'plugins/devvn-image-hotspot/devvn-image-hotspot.png' ),
				'group'       => $cerebrum_theme_required_plugins_groups['content'],
			),
			'ti-woocommerce-wishlist'                  => array(
				'title'       => esc_html__( 'TI WooCommerce Wishlist', 'cerebrum' ),
				'description' => '',
				'required'    => false,
				'logo'        => cerebrum_get_file_url( 'plugins/ti-woocommerce-wishlist/ti-woocommerce-wishlist.png' ),
				'group'       => $cerebrum_theme_required_plugins_groups['ecommerce'],
			),
			'woo-smart-quick-view'                  => array(
				'title'       => esc_html__( 'WPC Smart Quick View for WooCommerce', 'cerebrum' ),
				'description' => '',
				'required'    => false,
         			'install'     => false,
				'logo'        => cerebrum_get_file_url( 'plugins/woo-smart-quick-view/woo-smart-quick-view.png' ),
				'group'       => $cerebrum_theme_required_plugins_groups['ecommerce'],
			),
			'twenty20'                  => array(
				'title'       => esc_html__( 'Twenty20 Image Before-After', 'cerebrum' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => cerebrum_get_file_url( 'plugins/twenty20/twenty20.png' ),
				'group'       => $cerebrum_theme_required_plugins_groups['content'],
			),
			'essential-grid'             => array(
				'title'       => esc_html__( 'Essential Grid', 'cerebrum' ),
				'description' => '',
				'required'    => false,
				'install'     => false,
				'logo'        => 'essential-grid.png',
				'group'       => $cerebrum_theme_required_plugins_groups['content'],
			),
			'revslider'                  => array(
				'title'       => esc_html__( 'Revolution Slider', 'cerebrum' ),
				'description' => '',
				'required'    => false,
				'logo'        => 'revslider.png',
				'group'       => $cerebrum_theme_required_plugins_groups['content'],
			),
			'sitepress-multilingual-cms' => array(
				'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'cerebrum' ),
				'description' => esc_html__( "Allows you to make your website multilingual", 'cerebrum' ),
				'required'    => false,
				'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
				'logo'        => 'sitepress-multilingual-cms.png',
				'group'       => $cerebrum_theme_required_plugins_groups['content'],
			),
			'wp-gdpr-compliance'         => array(
				'title'       => esc_html__( 'Cookie Information', 'cerebrum' ),
				'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'cerebrum' ),
				'required'    => false,
				'install'     => false,
				'logo'        => 'wp-gdpr-compliance.png',
				'group'       => $cerebrum_theme_required_plugins_groups['other'],
			),
			'gdpr-framework'         => array(
				'title'       => esc_html__( 'The GDPR Framework', 'cerebrum' ),
				'description' => esc_html__( "Tools to help make your website GDPR-compliant. Fully documented, extendable and developer-friendly.", 'cerebrum' ),
				'required'    => false,
				'install'     => false,
				'logo'        => 'gdpr-framework.png',
				'group'       => $cerebrum_theme_required_plugins_groups['other'],
			),
			'trx_updater'                => array(
				'title'       => esc_html__( 'ThemeREX Updater', 'cerebrum' ),
				'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'cerebrum' ),
				'required'    => false,
				'logo'        => 'trx_updater.png',
				'group'       => $cerebrum_theme_required_plugins_groups['other'],
			),
		);

		if ( CEREBRUM_THEME_FREE ) {
			unset( $cerebrum_theme_required_plugins['js_composer'] );
			unset( $cerebrum_theme_required_plugins['booked'] );
			unset( $cerebrum_theme_required_plugins['quickcal'] );
			unset( $cerebrum_theme_required_plugins['the-events-calendar'] );
			unset( $cerebrum_theme_required_plugins['calculated-fields-form'] );
			unset( $cerebrum_theme_required_plugins['essential-grid'] );
			unset( $cerebrum_theme_required_plugins['revslider'] );
			unset( $cerebrum_theme_required_plugins['sitepress-multilingual-cms'] );
			unset( $cerebrum_theme_required_plugins['trx_updater'] );
			unset( $cerebrum_theme_required_plugins['trx_popup'] );
		}

		// Add plugins list to the global storage
		cerebrum_storage_set( 'required_plugins', $cerebrum_theme_required_plugins );
	}
}
