<?php
/**
 * Skin Setup
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.76.0
 */


//--------------------------------------------
// SKIN DEFAULTS
//--------------------------------------------

// Return theme's (skin's) default value for the specified parameter
if ( ! function_exists( 'cerebrum_theme_defaults' ) ) {
	function cerebrum_theme_defaults( $name='', $value='' ) {
		$defaults = array(
			'page_width'          => 1290,
			'page_boxed_extra'  => 60,
			'page_fullwide_max' => 1920,
			'page_fullwide_extra' => 60,
			'sidebar_width'       => 410,
			'sidebar_gap'       => 40,
			'grid_gap'          => 30,
			'rad'               => 0
		);
		if ( empty( $name ) ) {
			return $defaults;
		} else {
			if ( $value === '' && isset( $defaults[ $name ] ) ) {
				$value = $defaults[ $name ];
			}
			return $value;
		}
	}
}

// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)


//--------------------------------------------
// SKIN SETTINGS
//--------------------------------------------
if ( ! function_exists( 'cerebrum_skin_setup' ) ) {
	add_action( 'after_setup_theme', 'cerebrum_skin_setup', 1 );
	function cerebrum_skin_setup() {

		$GLOBALS['CEREBRUM_STORAGE'] = array_merge( $GLOBALS['CEREBRUM_STORAGE'], array(

			// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
			'theme_pro_key'       => 'env-axiom',

			'theme_doc_url'       => '//cerebrum.axiomthemes.com/doc',

			'theme_demofiles_url' => '//demofiles.axiomthemes.com/cerebrum/',
			
			'theme_rate_url'      => '//themeforest.net/download',

			'theme_custom_url'    => '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themeinstall',

			'theme_support_url'   => '//themerex.net/support/',

			'theme_download_url'  => '//themeforest.net/user/axiomthemes/portfolio',         // Axiom

            'theme_video_url'     => '//www.youtube.com/channel/UCBjqhuwKj3MfE3B6Hg2oA8Q',   // Axiom

            'theme_privacy_url'   => '//axiomthemes.com/privacy-policy/',                    // Axiom

            'portfolio_url'       => '//themeforest.net/user/axiomthemes/portfolio',         // Axiom

			// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
			// (i.e. 'children,kindergarten')
			'theme_categories'    => '',
		) );
	}
}


// Add/remove/change Theme Settings
if ( ! function_exists( 'cerebrum_skin_setup_settings' ) ) {
	add_action( 'after_setup_theme', 'cerebrum_skin_setup_settings', 1 );
	function cerebrum_skin_setup_settings() {
		// Example: enable (true) / disable (false) thumbs in the prev/next navigation
		cerebrum_storage_set_array( 'settings', 'thumbs_in_navigation', false );
		cerebrum_storage_set_array2( 'required_plugins', 'instagram-feed', 'install', false);
	}
}

// Add/remove/change Theme Options
if ( ! function_exists( 'cerebrum_skin_setup_options' ) ) {
    add_action( 'after_setup_theme', 'cerebrum_skin_setup_options', 3 );
    function cerebrum_skin_setup_options()  {
        cerebrum_storage_set_array2( 'options', 'footer_scheme', 'std', 'dark' );
    }
}

// Enqueue extra styles for frontend
if ( ! function_exists( 'cerebrum_trx_addons_extra_styles' ) ) {
    add_action( 'wp_enqueue_scripts', 'cerebrum_trx_addons_extra_styles', 2060 );
    function cerebrum_trx_addons_extra_styles() {
        $cerebrum_url = cerebrum_get_file_url( 'extra-styles.css' );
        if ( '' != $cerebrum_url ) {
            wp_enqueue_style( 'cerebrum-trx-addons-extra-styles', $cerebrum_url, array(), null );
        }
    }
}


//--------------------------------------------
// SKIN FONTS
//--------------------------------------------
if ( ! function_exists( 'cerebrum_skin_setup_fonts' ) ) {
	add_action( 'after_setup_theme', 'cerebrum_skin_setup_fonts', 1 );
	function cerebrum_skin_setup_fonts() {
		// Fonts to load when theme start
		// It can be:
		// - Google fonts (specify name, family and styles)
		// - Adobe fonts (specify name, family and link URL)
		// - uploaded fonts (specify name, family), placed in the folder css/font-face/font-name inside the skin folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		cerebrum_storage_set(
			'load_fonts', array(
				array(
					'name'   => 'museo-sans',
					'family' => 'sans-serif',
					'link'   => 'https://use.typekit.net/zfc0lca.css',
					'styles' => ''
				),
				array(
					'name'   => 'Frank Ruhl Libre',
                    'family' => 'sans-serif',
					'link'   => '',
					'styles' => 'wght@300;400;500;700;900'
				),
			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		cerebrum_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		// Settings of the main tags.
		// Default value of 'font-family' may be specified as reference to the array $load_fonts (see above)
		// or as comma-separated string.
		// In the second case (if 'font-family' is specified manually as comma-separated string):
		//    1) Font name with spaces in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
		//    2) If font-family inherit a value from the 'Main text' - specify 'inherit' as a value
		// example:
		// Correct:   'font-family' => basekit_get_load_fonts_family_string( $load_fonts[0] )
		// Correct:   'font-family' => 'Roboto,sans-serif'
		// Correct:   'font-family' => '"PT Serif",sans-serif'
		// Incorrect: 'font-family' => 'Roboto,sans-serif'
		// Incorrect: 'font-family' => 'PT Serif,sans-serif'

		$font_description = esc_html__( 'Font settings for the %s of the site. To ensure that the elements scale properly on mobile devices, please use only the following units: "rem", "em" or "ex"', 'cerebrum' );

		cerebrum_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'main text', 'cerebrum' ) ),
					'font-family'     => 'museo-sans,sans-serif',
					'font-size'       => '1rem',
					'font-weight'     => '300',
					'font-style'      => 'normal',
					'line-height'     => '1.58em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0',
					'margin-top'      => '0em',
					'margin-bottom'   => '1.57em',
				),
				'post'    => array(
					'title'           => esc_html__( 'Article text', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'article text', 'cerebrum' ) ),
					'font-family'     => '',			// Example: '"PR Serif",serif',
					'font-size'       => '',			// Example: '1.286rem',
					'font-weight'     => '',			// Example: '400',
					'font-style'      => '',			// Example: 'normal',
					'line-height'     => '',			// Example: '1.75em',
					'text-decoration' => '',			// Example: 'none',
					'text-transform'  => '',			// Example: 'none',
					'letter-spacing'  => '',			// Example: '',
					'margin-top'      => '',			// Example: '0em',
					'margin-bottom'   => '',			// Example: '1.4em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H1', 'cerebrum' ) ),
					'font-family'     => '"Frank Ruhl Libre",serif',
					'font-size'       => '3.35em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.01em',
					'margin-top'      => '1.1em',
					'margin-bottom'   => '0.4em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H2', 'cerebrum' ) ),
					'font-family'     => '"Frank Ruhl Libre",serif',
					'font-size'       => '2.76em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.021em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.83em',
					'margin-bottom'   => '0.45em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H3', 'cerebrum' ) ),
					'font-family'     => '"Frank Ruhl Libre",serif',
					'font-size'       => '2.06em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.086em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.14em',
					'margin-bottom'   => '0.55em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H4', 'cerebrum' ) ),
					'font-family'     => '"Frank Ruhl Libre",serif',
					'font-size'       => '1.647em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.214em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.55em',
					'margin-bottom'   => '0.83em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H5', 'cerebrum' ) ),
					'font-family'     => '"Frank Ruhl Libre",serif',
					'font-size'       => '1.411em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.417em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.3em',
					'margin-bottom'   => '0.84em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H6', 'cerebrum' ) ),
					'font-family'     => '"Frank Ruhl Libre",serif',
					'font-size'       => '1.23em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.474em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.75em',
					'margin-bottom'   => '1.1em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'text of the logo', 'cerebrum' ) ),
					'font-family'     => '"Frank Ruhl Libre",serif',
					'font-size'       => '1.7em',
					'font-weight'     => '500',
					'font-style'      => 'normal',
					'line-height'     => '1.25em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'buttons', 'cerebrum' ) ),
					'font-family'     => '"Frank Ruhl Libre",serif',
					'font-size'       => '15px',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '22px',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'input fields, dropdowns and textareas', 'cerebrum' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '16px',
					'font-weight'     => '300',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',     // Attention! Firefox don't allow line-height less then 1.5em in the select
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0.1px',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'post meta (author, categories, publish date, counters, share, etc.)', 'cerebrum' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '14px',  // Old value '13px' don't allow using 'font zoom' in the custom blog items
					'font-weight'     => '300',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.4em',
					'margin-bottom'   => '',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'main menu items', 'cerebrum' ) ),
					'font-family'     => '"Frank Ruhl Libre",serif',
					'font-size'       => '16px',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'dropdown menu items', 'cerebrum' ) ),
					'font-family'     => 'museo-sans,sans-serif',
					'font-size'       => '15px',
					'font-weight'     => '300',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0',
				),
				'other' => array(
					'title'           => esc_html__( 'Other', 'cerebrum' ),
					'description'     => sprintf( $font_description, esc_html__( 'specific elements', 'cerebrum' ) ),
					'font-family'     => '"Frank Ruhl Libre",serif',
				),
			)
		);

		// Font presets
		cerebrum_storage_set(
			'font_presets', array(
				'karla' => array(
								'title'  => esc_html__( 'Karla', 'cerebrum' ),
								'load_fonts' => array(
													// Google font
													array(
														'name'   => 'Dancing Script',
														'family' => 'fantasy',
														'link'   => '',
														'styles' => '300,400,700',
													),
													// Google font
													array(
														'name'   => 'Sansita Swashed',
														'family' => 'fantasy',
														'link'   => '',
														'styles' => '300,400,700',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Dancing Script",fantasy',
														'font-size'       => '1.25rem',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
														'font-size'       => '4em',
													),
													'h2'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h3'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h4'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h5'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h6'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'logo'    => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'button'  => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'submenu' => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
												),
							),
				'roboto' => array(
								'title'  => esc_html__( 'Roboto', 'cerebrum' ),
								'load_fonts' => array(
													// Google font
													array(
														'name'   => 'Noto Sans JP',
														'family' => 'serif',
														'link'   => '',
														'styles' => '300,300italic,400,400italic,700,700italic',
													),
													// Google font
													array(
														'name'   => 'Merriweather',
														'family' => 'sans-serif',
														'link'   => '',
														'styles' => '300,300italic,400,400italic,700,700italic',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Noto Sans JP",serif',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h2'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h3'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h4'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h5'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h6'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'logo'    => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'button'  => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'submenu' => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
												),
							),
				'garamond' => array(
								'title'  => esc_html__( 'Garamond', 'cerebrum' ),
								'load_fonts' => array(
													// Adobe font
													array(
														'name'   => 'Europe',
														'family' => 'sans-serif',
														'link'   => 'https://use.typekit.net/qmj1tmx.css',
														'styles' => '',
													),
													// Adobe font
													array(
														'name'   => 'Sofia Pro',
														'family' => 'sans-serif',
														'link'   => 'https://use.typekit.net/qmj1tmx.css',
														'styles' => '',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Sofia Pro",sans-serif',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h2'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h3'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h4'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h5'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h6'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'logo'    => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'button'  => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'submenu' => array(
														'font-family'     => 'Europe,sans-serif',
													),
												),
							),
			)
		);
	}
}


//--------------------------------------------
// COLOR SCHEMES
//--------------------------------------------
if ( ! function_exists( 'cerebrum_skin_setup_schemes' ) ) {
	add_action( 'after_setup_theme', 'cerebrum_skin_setup_schemes', 1 );
	function cerebrum_skin_setup_schemes() {

		// Theme colors for customizer
		// Attention! Inner scheme must be last in the array below
		cerebrum_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => esc_html__( 'Main', 'cerebrum' ),
					'description' => esc_html__( 'Colors of the main content area', 'cerebrum' ),
				),
				'alter'   => array(
					'title'       => esc_html__( 'Alter', 'cerebrum' ),
					'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'cerebrum' ),
				),
				'extra'   => array(
					'title'       => esc_html__( 'Extra', 'cerebrum' ),
					'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'cerebrum' ),
				),
				'inverse' => array(
					'title'       => esc_html__( 'Inverse', 'cerebrum' ),
					'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'cerebrum' ),
				),
				'input'   => array(
					'title'       => esc_html__( 'Input', 'cerebrum' ),
					'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'cerebrum' ),
				),
			)
		);

		cerebrum_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => esc_html__( 'Background color', 'cerebrum' ),
					'description' => esc_html__( 'Background color of this block in the normal state', 'cerebrum' ),
				),
				'bg_hover'    => array(
					'title'       => esc_html__( 'Background hover', 'cerebrum' ),
					'description' => esc_html__( 'Background color of this block in the hovered state', 'cerebrum' ),
				),
				'bd_color'    => array(
					'title'       => esc_html__( 'Border color', 'cerebrum' ),
					'description' => esc_html__( 'Border color of this block in the normal state', 'cerebrum' ),
				),
				'bd_hover'    => array(
					'title'       => esc_html__( 'Border hover', 'cerebrum' ),
					'description' => esc_html__( 'Border color of this block in the hovered state', 'cerebrum' ),
				),
				'text'        => array(
					'title'       => esc_html__( 'Text', 'cerebrum' ),
					'description' => esc_html__( 'Color of the text inside this block', 'cerebrum' ),
				),
				'text_dark'   => array(
					'title'       => esc_html__( 'Text dark', 'cerebrum' ),
					'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'cerebrum' ),
				),
				'text_light'  => array(
					'title'       => esc_html__( 'Text light', 'cerebrum' ),
					'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'cerebrum' ),
				),
				'text_link'   => array(
					'title'       => esc_html__( 'Link', 'cerebrum' ),
					'description' => esc_html__( 'Color of the links inside this block', 'cerebrum' ),
				),
				'text_hover'  => array(
					'title'       => esc_html__( 'Link hover', 'cerebrum' ),
					'description' => esc_html__( 'Color of the hovered state of links inside this block', 'cerebrum' ),
				),
				'text_link2'  => array(
					'title'       => esc_html__( 'Accent 2', 'cerebrum' ),
					'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'cerebrum' ),
				),
				'text_hover2' => array(
					'title'       => esc_html__( 'Accent 2 hover', 'cerebrum' ),
					'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'cerebrum' ),
				),
				'text_link3'  => array(
					'title'       => esc_html__( 'Accent 3', 'cerebrum' ),
					'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'cerebrum' ),
				),
				'text_hover3' => array(
					'title'       => esc_html__( 'Accent 3 hover', 'cerebrum' ),
					'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'cerebrum' ),
				),
			)
		);

		// Default values for each color scheme
		$schemes = array(

			// Color scheme: 'default'
			'default' => array(
				'title'    => esc_html__( 'Default', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F7F2EF', //ok +
					'bd_color'         => '#E3DFDA', //ok +

					// Text and links colors
					'text'             => '#65605F', //ok +
					'text_light'       => '#9F9C99', //ok +
					'text_dark'        => '#101010', //ok +
					'text_link'        => '#007E52', //ok +
					'text_hover'       => '#007149', //ok +
					'text_link2'       => '#A87252', //ok + 
					'text_hover2'      => '#986241', //ok +
					'text_link3'       => '#C5A48E', //ok +
					'text_hover3'      => '#AB8E7A', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF', //ok +
					'alter_bg_hover'   => '#EFE6E1', //ok +
					'alter_bd_color'   => '#E3DFDA', //ok +
					'alter_bd_hover'   => '#E0DBD4', //ok +
					'alter_text'       => '#65605F', //ok +
					'alter_light'      => '#9F9C99', //ok +
					'alter_dark'       => '#101010', //ok +
					'alter_link'       => '#007E52', //ok +
					'alter_hover'      => '#007149', //ok +
					'alter_link2'      => '#A87252', //ok +
					'alter_hover2'     => '#986241', //ok +
					'alter_link3'      => '#C5A48E', //ok +
					'alter_hover3'     => '#AB8E7A', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#007E52', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#A87252',
					'extra_hover2'     => '#986241',
					'extra_link3'      => '#C5A48E',
					'extra_hover3'     => '#AB8E7A',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //ok +
					'input_bg_hover'   => 'transparent', //ok +
					'input_bd_color'   => '#E3DFDA', //ok +
					'input_bd_hover'   => '#E0DBD4', //ok +
					'input_text'       => '#65605F', //ok +
					'input_light'      => '#9F9C99', //ok +
					'input_dark'       => '#101010', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#101010', //ok +
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#FFFFFF', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'dark'
			'dark'    => array(
				'title'    => esc_html__( 'Dark', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#090909', //ok +
					'bd_color'         => '#262626', //ok +

					// Text and links colors
					'text'             => '#D5D3D2', //ok +
					'text_light'       => '#808080', //ok +
					'text_dark'        => '#FFFFFF', //ok +
					'text_link'        => '#007E52', //ok +
					'text_hover'       => '#007149', //ok +
					'text_link2'       => '#A87252', //ok +
					'text_hover2'      => '#986241', //ok +
					'text_link3'       => '#C5A48E', //ok +
					'text_hover3'      => '#AB8E7A', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#131313', //ok +
					'alter_bg_hover'   => '#1F1F1F', //ok +
					'alter_bd_color'   => '#262626', //ok +
					'alter_bd_hover'   => '#343434', //ok +
					'alter_text'       => '#D5D3D2', //ok +
					'alter_light'      => '#808080', //ok +
					'alter_dark'       => '#FFFFFF', //ok +
					'alter_link'       => '#007E52', //ok +
					'alter_hover'      => '#007149', //ok +
					'alter_link2'      => '#A87252', //ok +
					'alter_hover2'     => '#986241', //ok +
					'alter_link3'      => '#C5A48E', //ok +
					'alter_hover3'     => '#AB8E7A', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#007E52', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#A87252',
					'extra_hover2'     => '#986241',
					'extra_link3'      => '#C5A48E',
					'extra_hover3'     => '#AB8E7A',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', //ok +
					'input_bg_hover'   => '#transparent', //ok +
					'input_bd_color'   => '#262626', //ok +
					'input_bd_hover'   => '#343434', //ok +
					'input_text'       => '#D5D3D2', //ok +
					'input_light'      => '#808080', //ok +
					'input_dark'       => '#FFFFFF', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#FFFFFF', //ok +
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#101010', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'light'
			'light' => array(
				'title'    => esc_html__( 'Light', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFFFFF', //ok +
					'bd_color'         => '#E3DFDA', //ok +

					// Text and links colors
					'text'             => '#65605F', //ok +
					'text_light'       => '#9F9C99', //ok +
					'text_dark'        => '#101010', //ok +
					'text_link'        => '#007E52', //ok +
					'text_hover'       => '#007149', //ok +
					'text_link2'       => '#A87252', //ok + 
					'text_hover2'      => '#986241', //ok +
					'text_link3'       => '#C5A48E', //ok +
					'text_hover3'      => '#AB8E7A', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F7F2EF', //ok +
					'alter_bg_hover'   => '#EFE6E1', //ok +
					'alter_bd_color'   => '#E3DFDA', //ok +
					'alter_bd_hover'   => '#E0DBD4', //ok +
					'alter_text'       => '#65605F', //ok +
					'alter_light'      => '#9F9C99', //ok +
					'alter_dark'       => '#101010', //ok +
					'alter_link'       => '#007E52', //ok +
					'alter_hover'      => '#007149', //ok +
					'alter_link2'      => '#A87252', //ok +
					'alter_hover2'     => '#986241', //ok +
					'alter_link3'      => '#C5A48E', //ok +
					'alter_hover3'     => '#AB8E7A', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#007E52', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#A87252',
					'extra_hover2'     => '#986241',
					'extra_link3'      => '#C5A48E',
					'extra_hover3'     => '#AB8E7A',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //ok +
					'input_bg_hover'   => 'transparent', //ok +
					'input_bd_color'   => '#E3DFDA', //ok +
					'input_bd_hover'   => '#E0DBD4', //ok +
					'input_text'       => '#65605F', //ok +
					'input_light'      => '#9F9C99', //ok +
					'input_dark'       => '#101010', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#101010', //ok +
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#FFFFFF', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'greeny_default'
			'greeny_default' => array(
				'title'    => esc_html__( 'Greeny Default', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FAF8F2', //ok +
					'bd_color'         => '#E3DFDA', //ok +

					// Text and links colors
					'text'             => '#65605F', //ok +
					'text_light'       => '#9F9C99', //ok +
					'text_dark'        => '#101010', //ok +
					'text_link'        => '#A6BF3F', //ok +
					'text_hover'       => '#9BB239', //ok +
					'text_link2'       => '#EBBD0F', //ok + 
					'text_hover2'      => '#E0B40B', //ok +
					'text_link3'       => '#CCA741', //ok +
					'text_hover3'      => '#C19F40', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF', //ok +
					'alter_bg_hover'   => '#F4F1E9', //ok +
					'alter_bd_color'   => '#E3DFDA', //ok +
					'alter_bd_hover'   => '#E0DBD4', //ok +
					'alter_text'       => '#65605F', //ok +
					'alter_light'      => '#9F9C99', //ok +
					'alter_dark'       => '#101010', //ok +
					'alter_link'       => '#A6BF3F', //ok +
					'alter_hover'      => '#9BB239', //ok +
					'alter_link2'      => '#EBBD0F', //ok +
					'alter_hover2'     => '#E0B40B', //ok +
					'alter_link3'      => '#CCA741', //ok +
					'alter_hover3'     => '#C19F40', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#A6BF3F', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#EBBD0F',
					'extra_hover2'     => '#E0B40B',
					'extra_link3'      => '#CCA741',
					'extra_hover3'     => '#C19F40',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //ok +
					'input_bg_hover'   => 'transparent', //ok +
					'input_bd_color'   => '#E3DFDA', //ok +
					'input_bd_hover'   => '#E0DBD4', //ok +
					'input_text'       => '#65605F', //ok +
					'input_light'      => '#9F9C99', //ok +
					'input_dark'       => '#101010', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#101010', //ok +
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#FFFFFF', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'greeny_dark'
			'greeny_dark'    => array(
				'title'    => esc_html__( 'Greeny Dark', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#090909', //ok +
					'bd_color'         => '#262626', //ok +

					// Text and links colors
					'text'             => '#D5D3D2', //ok +
					'text_light'       => '#808080', //ok +
					'text_dark'        => '#FFFFFF', //ok +
					'text_link'        => '#A6BF3F', //ok +
					'text_hover'       => '#9BB239', //ok +
					'text_link2'       => '#EBBD0F', //ok +
					'text_hover2'      => '#E0B40B', //ok +
					'text_link3'       => '#CCA741', //ok +
					'text_hover3'      => '#C19F40', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#131313', //ok +
					'alter_bg_hover'   => '#1F1F1F', //ok +
					'alter_bd_color'   => '#262626', //ok +
					'alter_bd_hover'   => '#343434', //ok +
					'alter_text'       => '#D5D3D2', //ok +
					'alter_light'      => '#808080', //ok +
					'alter_dark'       => '#FFFFFF', //ok +
					'alter_link'       => '#A6BF3F', //ok +
					'alter_hover'      => '#9BB239', //ok +
					'alter_link2'      => '#EBBD0F', //ok +
					'alter_hover2'     => '#E0B40B', //ok +
					'alter_link3'      => '#CCA741', //ok +
					'alter_hover3'     => '#C19F40', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#A6BF3F', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#EBBD0F',
					'extra_hover2'     => '#E0B40B',
					'extra_link3'      => '#CCA741',
					'extra_hover3'     => '#C19F40',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', //ok +
					'input_bg_hover'   => '#transparent', //ok +
					'input_bd_color'   => '#262626', //ok +
					'input_bd_hover'   => '#343434', //ok +
					'input_text'       => '#D5D3D2', //ok +
					'input_light'      => '#808080', //ok +
					'input_dark'       => '#FFFFFF', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#FFFFFF', //ok +
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#101010', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'greeny_light'
			'greeny_light' => array(
				'title'    => esc_html__( 'Greeny Light', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFFFFF', //ok +
					'bd_color'         => '#E3DFDA', //ok +

					// Text and links colors
					'text'             => '#65605F', //ok +
					'text_light'       => '#9F9C99', //ok +
					'text_dark'        => '#101010', //ok +
					'text_link'        => '#A6BF3F', //ok +
					'text_hover'       => '#9BB239', //ok +
					'text_link2'       => '#EBBD0F', //ok + 
					'text_hover2'      => '#E0B40B', //ok +
					'text_link3'       => '#CCA741', //ok +
					'text_hover3'      => '#C19F40', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FAF8F2', //ok +
					'alter_bg_hover'   => '#ECE8DC', //ok +
					'alter_bd_color'   => '#E3DFDA', //ok +
					'alter_bd_hover'   => '#E0DBD4', //ok +
					'alter_text'       => '#65605F', //ok +
					'alter_light'      => '#9F9C99', //ok +
					'alter_dark'       => '#101010', //ok +
					'alter_link'       => '#A6BF3F', //ok +
					'alter_hover'      => '#9BB239', //ok +
					'alter_link2'      => '#EBBD0F', //ok +
					'alter_hover2'     => '#E0B40B', //ok +
					'alter_link3'      => '#CCA741', //ok +
					'alter_hover3'     => '#C19F40', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#A6BF3F', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#EBBD0F',
					'extra_hover2'     => '#E0B40B',
					'extra_link3'      => '#CCA741',
					'extra_hover3'     => '#C19F40',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //ok +
					'input_bg_hover'   => 'transparent', //ok +
					'input_bd_color'   => '#E3DFDA', //ok +
					'input_bd_hover'   => '#E0DBD4', //ok +
					'input_text'       => '#65605F', //ok +
					'input_light'      => '#9F9C99', //ok +
					'input_dark'       => '#101010', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#101010', //ok +
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#FFFFFF', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'frosty_default'
			'frosty_default' => array(
				'title'    => esc_html__( 'Frosty Default', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#EBF3FF', //ok +
					'bd_color'         => '#D5DEEE', //ok +

					// Text and links colors
					'text'             => '#65605F', //ok +
					'text_light'       => '#999A9F', //ok +
					'text_dark'        => '#101010', //ok +
					'text_link'        => '#325BDE', //ok +
					'text_hover'       => '#264FD1', //ok +
					'text_link2'       => '#E38E44', //ok + 
					'text_hover2'      => '#D88136', //ok +
					'text_link3'       => '#A0C3FF', //ok +
					'text_hover3'      => '#93B8F7', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF', //ok +
					'alter_bg_hover'   => '#E2EAF5', //ok +
					'alter_bd_color'   => '#D5DEEE', //ok +
					'alter_bd_hover'   => '#CED1D7', //ok +
					'alter_text'       => '#65605F', //ok +
					'alter_light'      => '#999A9F', //ok +
					'alter_dark'       => '#101010', //ok +
					'alter_link'       => '#325BDE', //ok +
					'alter_hover'      => '#264FD1', //ok +
					'alter_link2'      => '#E38E44', //ok +
					'alter_hover2'     => '#D88136', //ok +
					'alter_link3'      => '#A0C3FF', //ok +
					'alter_hover3'     => '#93B8F7', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#325BDE', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#E38E44',
					'extra_hover2'     => '#D88136',
					'extra_link3'      => '#A0C3FF',
					'extra_hover3'     => '#93B8F7',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //ok +
					'input_bg_hover'   => 'transparent', //ok +
					'input_bd_color'   => '#D5DEEE', //ok +
					'input_bd_hover'   => '#CED1D7', //ok +
					'input_text'       => '#65605F', //ok +
					'input_light'      => '#999A9F', //ok +
					'input_dark'       => '#101010', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#101010', //ok +
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#FFFFFF', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'frosty_dark'
			'frosty_dark'    => array(
				'title'    => esc_html__( 'Frosty Dark', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#090909', //ok +
					'bd_color'         => '#262626', //ok +

					// Text and links colors
					'text'             => '#D5D3D2', //ok +
					'text_light'       => '#808080', //ok +
					'text_dark'        => '#FFFFFF', //ok +
					'text_link'        => '#325BDE', //ok +
					'text_hover'       => '#264FD1', //ok +
					'text_link2'       => '#E38E44', //ok +
					'text_hover2'      => '#D88136', //ok +
					'text_link3'       => '#A0C3FF', //ok +
					'text_hover3'      => '#93B8F7', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#131313', //ok +
					'alter_bg_hover'   => '#1F1F1F', //ok +
					'alter_bd_color'   => '#262626', //ok +
					'alter_bd_hover'   => '#343434', //ok +
					'alter_text'       => '#D5D3D2', //ok +
					'alter_light'      => '#808080', //ok +
					'alter_dark'       => '#FFFFFF', //ok +
					'alter_link'       => '#325BDE', //ok +
					'alter_hover'      => '#264FD1', //ok +
					'alter_link2'      => '#E38E44', //ok +
					'alter_hover2'     => '#D88136', //ok +
					'alter_link3'      => '#A0C3FF', //ok +
					'alter_hover3'     => '#93B8F7', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#325BDE', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#E38E44',
					'extra_hover2'     => '#D88136',
					'extra_link3'      => '#A0C3FF',
					'extra_hover3'     => '#93B8F7',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', //ok +
					'input_bg_hover'   => '#transparent', //ok +
					'input_bd_color'   => '#262626', //ok +
					'input_bd_hover'   => '#343434', //ok +
					'input_text'       => '#D5D3D2', //ok +
					'input_light'      => '#808080', //ok +
					'input_dark'       => '#FFFFFF', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#FFFFFF', //ok +
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#101010', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
			
			// Color scheme: 'frosty_light'
			'frosty_light' => array(
				'title'    => esc_html__( 'Frosty Light', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFFFFF', //ok +
					'bd_color'         => '#D5DEEE', //ok +

					// Text and links colors
					'text'             => '#65605F', //ok +
					'text_light'       => '#999A9F', //ok +
					'text_dark'        => '#101010', //ok +
					'text_link'        => '#325BDE', //ok +
					'text_hover'       => '#264FD1', //ok +
					'text_link2'       => '#E38E44', //ok + 
					'text_hover2'      => '#D88136', //ok +
					'text_link3'       => '#A0C3FF', //ok +
					'text_hover3'      => '#93B8F7', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#EBF3FF', //ok +
					'alter_bg_hover'   => '#D3DFF2', //ok +
					'alter_bd_color'   => '#D5DEEE', //ok +
					'alter_bd_hover'   => '#CED1D7', //ok +
					'alter_text'       => '#65605F', //ok +
					'alter_light'      => '#999A9F', //ok +
					'alter_dark'       => '#101010', //ok +
					'alter_link'       => '#325BDE', //ok +
					'alter_hover'      => '#264FD1', //ok +
					'alter_link2'      => '#E38E44', //ok +
					'alter_hover2'     => '#D88136', //ok +
					'alter_link3'      => '#A0C3FF', //ok +
					'alter_hover3'     => '#93B8F7', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#325BDE', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#E38E44',
					'extra_hover2'     => '#D88136',
					'extra_link3'      => '#A0C3FF',
					'extra_hover3'     => '#93B8F7',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //ok +
					'input_bg_hover'   => 'transparent', //ok +
					'input_bd_color'   => '#D5DEEE', //ok +
					'input_bd_hover'   => '#CED1D7', //ok +
					'input_text'       => '#65605F', //ok +
					'input_light'      => '#999A9F', //ok +
					'input_dark'       => '#101010', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#101010', //ok +
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#FFFFFF', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'orange_default'
			'orange_default' => array(
				'title'    => esc_html__( 'Orange Default', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFF5EF', //ok +
					'bd_color'         => '#E3DFDA', //ok +

					// Text and links colors
					'text'             => '#65605F', //ok +
					'text_light'       => '#9F9C99', //ok +
					'text_dark'        => '#101010', //ok +
					'text_link'        => '#FF6A0D', //ok +
					'text_hover'       => '#EA6412', //ok +
					'text_link2'       => '#B1CB46', //ok + 
					'text_hover2'      => '#9FB933', //ok +
					'text_link3'       => '#D8BB50', //ok +
					'text_hover3'      => '#C7AB44', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF', //ok +
					'alter_bg_hover'   => '#F7ECE5', //ok +
					'alter_bd_color'   => '#E3DFDA', //ok +
					'alter_bd_hover'   => '#E0DBD4', //ok +
					'alter_text'       => '#65605F', //ok +
					'alter_light'      => '#9F9C99', //ok +
					'alter_dark'       => '#101010', //ok +
					'alter_link'       => '#FF6A0D', //ok +
					'alter_hover'      => '#EA6412', //ok +
					'alter_link2'      => '#B1CB46', //ok +
					'alter_hover2'     => '#9FB933', //ok +
					'alter_link3'      => '#D8BB50', //ok +
					'alter_hover3'     => '#C7AB44', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#FF6A0D', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#B1CB46',
					'extra_hover2'     => '#9FB933',
					'extra_link3'      => '#D8BB50',
					'extra_hover3'     => '#C7AB44',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //ok +
					'input_bg_hover'   => 'transparent', //ok +
					'input_bd_color'   => '#E3DFDA', //ok +
					'input_bd_hover'   => '#E0DBD4', //ok +
					'input_text'       => '#65605F', //ok +
					'input_light'      => '#9F9C99', //ok +
					'input_dark'       => '#101010', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#101010', //ok +
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#FFFFFF', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'orange_dark'
			'orange_dark'    => array(
				'title'    => esc_html__( 'Orange Dark', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#090909', //ok +
					'bd_color'         => '#262626', //ok +

					// Text and links colors
					'text'             => '#D5D3D2', //ok +
					'text_light'       => '#808080', //ok +
					'text_dark'        => '#FFFFFF', //ok +
					'text_link'        => '#FF6A0D', //ok +
					'text_hover'       => '#EA6412', //ok +
					'text_link2'       => '#B1CB46', //ok +
					'text_hover2'      => '#9FB933', //ok +
					'text_link3'       => '#D8BB50', //ok +
					'text_hover3'      => '#C7AB44', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#131313', //ok +
					'alter_bg_hover'   => '#1F1F1F', //ok +
					'alter_bd_color'   => '#262626', //ok +
					'alter_bd_hover'   => '#343434', //ok +
					'alter_text'       => '#D5D3D2', //ok +
					'alter_light'      => '#808080', //ok +
					'alter_dark'       => '#FFFFFF', //ok +
					'alter_link'       => '#FF6A0D', //ok +
					'alter_hover'      => '#EA6412', //ok +
					'alter_link2'      => '#B1CB46', //ok +
					'alter_hover2'     => '#9FB933', //ok +
					'alter_link3'      => '#D8BB50', //ok +
					'alter_hover3'     => '#C7AB44', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#FF6A0D', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#B1CB46',
					'extra_hover2'     => '#9FB933',
					'extra_link3'      => '#D8BB50',
					'extra_hover3'     => '#C7AB44',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', //ok +
					'input_bg_hover'   => '#transparent', //ok +
					'input_bd_color'   => '#262626', //ok +
					'input_bd_hover'   => '#343434', //ok +
					'input_text'       => '#D5D3D2', //ok +
					'input_light'      => '#808080', //ok +
					'input_dark'       => '#FFFFFF', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#FFFFFF', //ok +
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#101010', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'orange_light'
			'orange_light' => array(
				'title'    => esc_html__( 'Orange Light', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFFFFF', //ok +
					'bd_color'         => '#E3DFDA', //ok +

					// Text and links colors
					'text'             => '#65605F', //ok +
					'text_light'       => '#9F9C99', //ok +
					'text_dark'        => '#101010', //ok +
					'text_link'        => '#FF6A0D', //ok +
					'text_hover'       => '#EA6412', //ok +
					'text_link2'       => '#B1CB46', //ok + 
					'text_hover2'      => '#9FB933', //ok +
					'text_link3'       => '#D8BB50', //ok +
					'text_hover3'      => '#C7AB44', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFF5EF', //ok +
					'alter_bg_hover'   => '#F4E3D7', //ok +
					'alter_bd_color'   => '#E3DFDA', //ok +
					'alter_bd_hover'   => '#E0DBD4', //ok +
					'alter_text'       => '#65605F', //ok +
					'alter_light'      => '#9F9C99', //ok +
					'alter_dark'       => '#101010', //ok +
					'alter_link'       => '#FF6A0D', //ok +
					'alter_hover'      => '#EA6412', //ok +
					'alter_link2'      => '#B1CB46', //ok +
					'alter_hover2'     => '#9FB933', //ok +
					'alter_link3'      => '#D8BB50', //ok +
					'alter_hover3'     => '#C7AB44', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#FF6A0D', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#B1CB46',
					'extra_hover2'     => '#9FB933',
					'extra_link3'      => '#D8BB50',
					'extra_hover3'     => '#C7AB44',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //ok +
					'input_bg_hover'   => 'transparent', //ok +
					'input_bd_color'   => '#E3DFDA', //ok +
					'input_bd_hover'   => '#E0DBD4', //ok +
					'input_text'       => '#65605F', //ok +
					'input_light'      => '#9F9C99', //ok +
					'input_dark'       => '#101010', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#101010', //ok +
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#FFFFFF', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'grassy_default'
			'grassy_default' => array(
				'title'    => esc_html__( 'Grassy Default', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F4F3EC', //ok +
					'bd_color'         => '#E3DFDA', //ok +

					// Text and links colors
					'text'             => '#65605F', //ok +
					'text_light'       => '#9F9C99', //ok +
					'text_dark'        => '#101010', //ok +
					'text_link'        => '#6A9535', //ok +
					'text_hover'       => '#5B832A', //ok +
					'text_link2'       => '#A7A232', //ok + 
					'text_hover2'      => '#9A952B', //ok +
					'text_link3'       => '#D8BB50', //ok +
					'text_hover3'      => '#C7AB44', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF', //ok +
					'alter_bg_hover'   => '#EDEAE2', //ok +
					'alter_bd_color'   => '#E3DFDA', //ok +
					'alter_bd_hover'   => '#E0DBD4', //ok +
					'alter_text'       => '#65605F', //ok +
					'alter_light'      => '#9F9C99', //ok +
					'alter_dark'       => '#101010', //ok +
					'alter_link'       => '#6A9535', //ok +
					'alter_hover'      => '#5B832A', //ok +
					'alter_link2'      => '#A7A232', //ok +
					'alter_hover2'     => '#9A952B', //ok +
					'alter_link3'      => '#D8BB50', //ok +
					'alter_hover3'     => '#C7AB44', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#6A9535', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#A7A232',
					'extra_hover2'     => '#9A952B',
					'extra_link3'      => '#D8BB50',
					'extra_hover3'     => '#C7AB44',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //ok +
					'input_bg_hover'   => 'transparent', //ok +
					'input_bd_color'   => '#E3DFDA', //ok +
					'input_bd_hover'   => '#E0DBD4', //ok +
					'input_text'       => '#65605F', //ok +
					'input_light'      => '#9F9C99', //ok +
					'input_dark'       => '#101010', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#101010', //ok +
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#FFFFFF', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'grassy_dark'
			'grassy_dark'    => array(
				'title'    => esc_html__( 'Grassy Dark', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#090909', //ok +
					'bd_color'         => '#262626', //ok +

					// Text and links colors
					'text'             => '#D5D3D2', //ok +
					'text_light'       => '#808080', //ok +
					'text_dark'        => '#FFFFFF', //ok +
					'text_link'        => '#6A9535', //ok +
					'text_hover'       => '#5B832A', //ok +
					'text_link2'       => '#A7A232', //ok +
					'text_hover2'      => '#9A952B', //ok +
					'text_link3'       => '#D8BB50', //ok +
					'text_hover3'      => '#C7AB44', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#131313', //ok +
					'alter_bg_hover'   => '#1F1F1F', //ok +
					'alter_bd_color'   => '#262626', //ok +
					'alter_bd_hover'   => '#343434', //ok +
					'alter_text'       => '#D5D3D2', //ok +
					'alter_light'      => '#808080', //ok +
					'alter_dark'       => '#FFFFFF', //ok +
					'alter_link'       => '#6A9535', //ok +
					'alter_hover'      => '#5B832A', //ok +
					'alter_link2'      => '#A7A232', //ok +
					'alter_hover2'     => '#9A952B', //ok +
					'alter_link3'      => '#D8BB50', //ok +
					'alter_hover3'     => '#C7AB44', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#6A9535', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#A7A232',
					'extra_hover2'     => '#9A952B',
					'extra_link3'      => '#D8BB50',
					'extra_hover3'     => '#C7AB44',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', //ok +
					'input_bg_hover'   => '#transparent', //ok +
					'input_bd_color'   => '#262626', //ok +
					'input_bd_hover'   => '#343434', //ok +
					'input_text'       => '#D5D3D2', //ok +
					'input_light'      => '#808080', //ok +
					'input_dark'       => '#FFFFFF', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#FFFFFF', //ok +
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#101010', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'grassy_light'
			'grassy_light' => array(
				'title'    => esc_html__( 'Grassy Light', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFFFFF', //ok +
					'bd_color'         => '#E3DFDA', //ok +

					// Text and links colors
					'text'             => '#65605F', //ok +
					'text_light'       => '#9F9C99', //ok +
					'text_dark'        => '#101010', //ok +
					'text_link'        => '#6A9535', //ok +
					'text_hover'       => '#5B832A', //ok +
					'text_link2'       => '#A7A232', //ok + 
					'text_hover2'      => '#9A952B', //ok +
					'text_link3'       => '#D8BB50', //ok +
					'text_hover3'      => '#C7AB44', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F4F3EC', //ok +
					'alter_bg_hover'   => '#E6E1D7', //ok +
					'alter_bd_color'   => '#E3DFDA', //ok +
					'alter_bd_hover'   => '#E0DBD4', //ok +
					'alter_text'       => '#65605F', //ok +
					'alter_light'      => '#9F9C99', //ok +
					'alter_dark'       => '#101010', //ok +
					'alter_link'       => '#6A9535', //ok +
					'alter_hover'      => '#5B832A', //ok +
					'alter_link2'      => '#A7A232', //ok +
					'alter_hover2'     => '#9A952B', //ok +
					'alter_link3'      => '#D8BB50', //ok +
					'alter_hover3'     => '#C7AB44', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#040404', //ok +
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#6A9535', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#A7A232',
					'extra_hover2'     => '#9A952B',
					'extra_link3'      => '#D8BB50',
					'extra_hover3'     => '#C7AB44',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //ok +
					'input_bg_hover'   => 'transparent', //ok +
					'input_bd_color'   => '#E3DFDA', //ok +
					'input_bd_hover'   => '#E0DBD4', //ok +
					'input_text'       => '#65605F', //ok +
					'input_light'      => '#9F9C99', //ok +
					'input_dark'       => '#101010', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#101010', //ok +
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#101010', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#FFFFFF', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'coffee_default'
			'coffee_default' => array(
				'title'    => esc_html__( 'Coffee Default', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F7F2EF', //ok +
					'bd_color'         => '#DBD2CD', //ok +

					// Text and links colors
					'text'             => '#858689', //ok +
					'text_light'       => '#999CA7', //ok +
					'text_dark'        => '#28282E', //ok +
					'text_link'        => '#7B5440', //ok +
					'text_hover'       => '#603F2E', //ok +
					'text_link2'       => '#7B7B40', //ok + 
					'text_hover2'      => '#60602B', //ok +
					'text_link3'       => '#7E808A', //ok +
					'text_hover3'      => '#5F6169', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF', //ok +
					'alter_bg_hover'   => '#EFE7E2', //ok +
					'alter_bd_color'   => '#DBD2CD', //ok +
					'alter_bd_hover'   => '#C3BAB5', //ok +
					'alter_text'       => '#858689', //ok +
					'alter_light'      => '#999CA7', //ok +
					'alter_dark'       => '#28282E', //ok +
					'alter_link'       => '#7B5440', //ok +
					'alter_hover'      => '#603F2E', //ok +
					'alter_link2'      => '#7B7B40', //ok +
					'alter_hover2'     => '#60602B', //ok +
					'alter_link3'      => '#7E808A', //ok +
					'alter_hover3'     => '#5F6169', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1A0C05', //ok +
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#7B5440', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#7B7B40',
					'extra_hover2'     => '#60602B',
					'extra_link3'      => '#7E808A',
					'extra_hover3'     => '#5F6169',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //ok +
					'input_bg_hover'   => 'transparent', //ok +
					'input_bd_color'   => '#DBD2CD', //ok +
					'input_bd_hover'   => '#C3BAB5', //ok +
					'input_text'       => '#858689', //ok +
					'input_light'      => '#999CA7', //ok +
					'input_dark'       => '#28282E', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#28282E', //ok +
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#28282E', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#FFFFFF', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'coffee_dark'
			'coffee_dark'    => array(
				'title'    => esc_html__( 'Coffee Dark', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#130701', //ok +
					'bd_color'         => '#3B3633', //ok +

					// Text and links colors
					'text'             => '#CAC2C0', //ok +
					'text_light'       => '#958F8C', //ok +
					'text_dark'        => '#FFFFFF', //ok +
					'text_link'        => '#7B5440', //ok +
					'text_hover'       => '#603F2E', //ok +
					'text_link2'       => '#7B7B40', //ok +
					'text_hover2'      => '#60602B', //ok +
					'text_link3'       => '#7E808A', //ok +
					'text_hover3'      => '#5F6169', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#1F140E', //ok +
					'alter_bg_hover'   => '#2b201a', //ok +
					'alter_bd_color'   => '#3B3633', //ok +
					'alter_bd_hover'   => '#898380', //ok +
					'alter_text'       => '#CAC2C0', //ok +
					'alter_light'      => '#958F8C', //ok +
					'alter_dark'       => '#FFFFFF', //ok +
					'alter_link'       => '#7B5440', //ok +
					'alter_hover'      => '#603F2E', //ok +
					'alter_link2'      => '#7B7B40', //ok +
					'alter_hover2'     => '#60602B', //ok +
					'alter_link3'      => '#7E808A', //ok +
					'alter_hover3'     => '#5F6169', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1A0C05', //ok +
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#7B5440', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#7B7B40',
					'extra_hover2'     => '#60602B',
					'extra_link3'      => '#7E808A',
					'extra_hover3'     => '#5F6169',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', //ok +
					'input_bg_hover'   => '#transparent', //ok +
					'input_bd_color'   => '#3B3633', //ok +
					'input_bd_hover'   => '#898380', //ok +
					'input_text'       => '#CAC2C0', //ok +
					'input_light'      => '#958F8C', //ok +
					'input_dark'       => '#FFFFFF', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#FFFFFF', //ok +
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#28282E', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#28282E', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'coffee_light'
			'coffee_light' => array(
				'title'    => esc_html__( 'Coffee Light', 'cerebrum' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFFFFF', //ok +
					'bd_color'         => '#DBD2CD', //ok +

					// Text and links colors
					'text'             => '#858689', //ok +
					'text_light'       => '#999CA7', //ok +
					'text_dark'        => '#28282E', //ok +
					'text_link'        => '#7B5440', //ok +
					'text_hover'       => '#603F2E', //ok +
					'text_link2'       => '#7B7B40', //ok + 
					'text_hover2'      => '#60602B', //ok +
					'text_link3'       => '#7E808A', //ok +
					'text_hover3'      => '#5F6169', //ok +

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F7F2EF', //ok +
					'alter_bg_hover'   => '#EADFD8', //ok +
					'alter_bd_color'   => '#DBD2CD', //ok +
					'alter_bd_hover'   => '#C3BAB5', //ok +
					'alter_text'       => '#858689', //ok +
					'alter_light'      => '#999CA7', //ok +
					'alter_dark'       => '#28282E', //ok +
					'alter_link'       => '#7B5440', //ok +
					'alter_hover'      => '#603F2E', //ok +
					'alter_link2'      => '#7B7B40', //ok +
					'alter_hover2'     => '#60602B', //ok +
					'alter_link3'      => '#7E808A', //ok +
					'alter_hover3'     => '#5F6169', //ok +

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1A0C05', //ok +
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A2A2A2', //ok +
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#FFFFFF', //ok +
					'extra_link'       => '#7B5440', //ok +
					'extra_hover'      => '#FFFFFF', //ok +
					'extra_link2'      => '#7B7B40',
					'extra_hover2'     => '#60602B',
					'extra_link3'      => '#7E808A',
					'extra_hover3'     => '#5F6169',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent', //ok +
					'input_bg_hover'   => 'transparent', //ok +
					'input_bd_color'   => '#DBD2CD', //ok +
					'input_bd_hover'   => '#C3BAB5', //ok +
					'input_text'       => '#858689', //ok +
					'input_light'      => '#999CA7', //ok +
					'input_dark'       => '#28282E', //ok +

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#28282E', //ok +
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#28282E', //ok +
					'inverse_link'     => '#FFFFFF', //ok +
					'inverse_hover'    => '#FFFFFF', //ok +

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

		);
		cerebrum_storage_set( 'schemes', $schemes );
		cerebrum_storage_set( 'schemes_original', $schemes );

		// Add names of additional colors
		//---> For example:
		//---> cerebrum_storage_set_array( 'scheme_color_names', 'new_color1', array(
		//---> 	'title'       => __( 'New color 1', 'cerebrum' ),
		//---> 	'description' => __( 'Description of the new color 1', 'cerebrum' ),
		//---> ) );


		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		cerebrum_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_00' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_color',
					'alpha' => 0.2,
				),
                'alter_dark_015'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.15,
                ),
                'alter_dark_02'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.2,
                ),
                'alter_dark_05'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.5,
                ),
                'alter_dark_08'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.8,
                ),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_05' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.5,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
                'text_dark_003'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.03,
                ),
                'text_dark_005'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.05,
                ),
                'text_dark_008'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.08,
                ),
				'text_dark_015'      => array(
					'color' => 'text_dark',
					'alpha' => 0.15,
				),
				'text_dark_02'      => array(
					'color' => 'text_dark',
					'alpha' => 0.2,
				),
                'text_dark_03'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.3,
                ),
                'text_dark_05'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.5,
                ),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
                'text_dark_08'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.8,
                ),
                'text_link_007'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.07,
                ),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
                'text_link_03'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.3,
                ),
				'text_link_04'      => array(
					'color' => 'text_link',
					'alpha' => 0.4,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
				'text_link2_08'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.8,
                ),
                'text_link2_007'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.07,
                ),
				'text_link2_02'      => array(
					'color' => 'text_link2',
					'alpha' => 0.2,
				),
                'text_link2_03'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.3,
                ),
				'text_link2_05'      => array(
					'color' => 'text_link2',
					'alpha' => 0.5,
				),
                'text_link3_007'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.07,
                ),
				'text_link3_02'      => array(
					'color' => 'text_link3',
					'alpha' => 0.2,
				),
                'text_link3_03'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.3,
                ),
                'inverse_text_03'      => array(
                    'color' => 'inverse_text',
                    'alpha' => 0.3,
                ),
                'inverse_link_08'      => array(
                    'color' => 'inverse_link',
                    'alpha' => 0.8,
                ),
                'inverse_hover_08'      => array(
                    'color' => 'inverse_hover',
                    'alpha' => 0.8,
                ),
				'text_dark_blend'   => array(
					'color'      => 'text_dark',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
			)
		);

		// Simple scheme editor: lists the colors to edit in the "Simple" mode.
		// For each color you can set the array of 'slave' colors and brightness factors that are used to generate new values,
		// when 'main' color is changed
		// Leave 'slave' arrays empty if your scheme does not have a color dependency
		cerebrum_storage_set(
			'schemes_simple', array(
				'text_link'        => array(),
				'text_hover'       => array(),
				'text_link2'       => array(),
				'text_hover2'      => array(),
				'text_link3'       => array(),
				'text_hover3'      => array(),
				'alter_link'       => array(),
				'alter_hover'      => array(),
				'alter_link2'      => array(),
				'alter_hover2'     => array(),
				'alter_link3'      => array(),
				'alter_hover3'     => array(),
				'extra_link'       => array(),
				'extra_hover'      => array(),
				'extra_link2'      => array(),
				'extra_hover2'     => array(),
				'extra_link3'      => array(),
				'extra_hover3'     => array(),
			)
		);

		// Parameters to set order of schemes in the css
		cerebrum_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);

		// Color presets
		cerebrum_storage_set(
			'color_presets', array(
				'autumn' => array(
								'title'  => esc_html__( 'Autumn', 'cerebrum' ),
								'colors' => array(
												'default' => array(
																	'text_link'  => '#d83938',
																	'text_hover' => '#f2b232',
																	),
												'dark' => array(
																	'text_link'  => '#d83938',
																	'text_hover' => '#f2b232',
																	)
												)
							),
				'green' => array(
								'title'  => esc_html__( 'Natural Green', 'cerebrum' ),
								'colors' => array(
												'default' => array(
																	'text_link'  => '#75ac78',
																	'text_hover' => '#378e6d',
																	),
												'dark' => array(
																	'text_link'  => '#75ac78',
																	'text_hover' => '#378e6d',
																	)
												)
							),
			)
		);
	}
}

// Activation methods
if ( ! function_exists( 'cerebrum_skin_filter_activation_methods2' ) ) {
    add_filter( 'trx_addons_filter_activation_methods', 'cerebrum_skin_filter_activation_methods2', 11, 1 );
    function cerebrum_skin_filter_activation_methods2( $args ) {
        $args['elements_key'] = true;
        return $args;
    }
}
