<?php
/**
 * The template to display Admin notices
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0.1
 */

$cerebrum_theme_slug = get_option( 'template' );
$cerebrum_theme_obj  = wp_get_theme( $cerebrum_theme_slug );
?>
<div class="cerebrum_admin_notice cerebrum_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$cerebrum_theme_img = cerebrum_get_file_url( 'screenshot.jpg' );
	if ( '' != $cerebrum_theme_img ) {
		?>
		<div class="cerebrum_notice_image"><img src="<?php echo esc_url( $cerebrum_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'cerebrum' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="cerebrum_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'cerebrum' ),
				$cerebrum_theme_obj->get( 'Name' ) . ( CEREBRUM_THEME_FREE ? ' ' . __( 'Free', 'cerebrum' ) : '' ),
				$cerebrum_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="cerebrum_notice_text">
		<p class="cerebrum_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $cerebrum_theme_obj->description ) );
			?>
		</p>
		<p class="cerebrum_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'cerebrum' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="cerebrum_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=cerebrum_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'cerebrum' );
			?>
		</a>
	</div>
</div>
