<?php
/**
 * The template to display the Author bio
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0
 */
?>

<div class="author_info author vcard"<?php
	if ( cerebrum_is_on( cerebrum_get_theme_option( 'seo_snippets' ) ) ) {
		?> itemprop="author" itemscope="itemscope" itemtype="<?php echo esc_attr( cerebrum_get_protocol( true ) ); ?>//schema.org/Person"<?php
	}
?>>

	<div class="author_avatar"<?php
		if ( cerebrum_is_on( cerebrum_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="image"<?php
	}
	?>>
		<a class="author_avatar_link" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
			<?php
			$cerebrum_mult = cerebrum_get_retina_multiplier();
			echo get_avatar( get_the_author_meta( 'user_email' ), 120 * $cerebrum_mult );
			?>
		</a>
	</div>

	<div class="author_description">
		<h5 class="author_title"<?php
			if ( cerebrum_is_on( cerebrum_get_theme_option( 'seo_snippets' ) ) ) {
				?> itemprop="name"<?php
			}
		?>><a class="author_link fn" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author"><?php
			the_author();
		?></a></h5>
		<div class="author_label"><?php esc_html_e( 'About Author', 'cerebrum' ); ?></div>
		<div class="author_bio"<?php
			if ( cerebrum_is_on( cerebrum_get_theme_option( 'seo_snippets' ) ) ) {
				?> itemprop="description"<?php
			}
		?>>
			<?php echo wp_kses( wpautop( get_the_author_meta( 'description' ) ), 'cerebrum_kses_content' ); ?>
			<div class="author_links">
				<?php do_action( 'cerebrum_action_user_meta', 'author-bio' ); ?>
			</div>
		</div>

	</div>

</div>
