<?php
/**
 * The template to display the user's avatar, bio and socials on the Author page
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.71.0
 */
?>

<div class="author_page author vcard"<?php
	if ( cerebrum_is_on( cerebrum_get_theme_option( 'seo_snippets' ) ) ) {
		?> itemprop="author" itemscope="itemscope" itemtype="<?php echo esc_attr( cerebrum_get_protocol( true ) ); ?>//schema.org/Person"<?php
	}
?>>

	<div class="author_avatar"<?php
		if ( cerebrum_is_on( cerebrum_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="image"<?php
		}
	?>>
		<?php
		$cerebrum_mult = cerebrum_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120 * $cerebrum_mult );
		?>
	</div>

	<h4 class="author_title"<?php
		if ( cerebrum_is_on( cerebrum_get_theme_option( 'seo_snippets' ) ) ) {
			?> itemprop="name"<?php
		}
	?>><span class="fn"><?php the_author(); ?></span></h4>

	<?php
	$cerebrum_author_description = get_the_author_meta( 'description' );
	if ( ! empty( $cerebrum_author_description ) ) {
		?>
		<div class="author_bio"<?php
			if ( cerebrum_is_on( cerebrum_get_theme_option( 'seo_snippets' ) ) ) {
				?> itemprop="description"<?php
			}
		?>><?php echo wp_kses( wpautop( $cerebrum_author_description ), 'cerebrum_kses_content' ); ?></div>
		<?php
	}
	?>

	<div class="author_details">
		<span class="author_posts_total">
			<?php
			$cerebrum_posts_total = count_user_posts( get_the_author_meta('ID'), 'post' );
			if ( $cerebrum_posts_total > 0 ) {
				// Translators: Add the author's posts number to the message
				echo wp_kses( sprintf( _n( '%s article published', '%s articles published', $cerebrum_posts_total, 'cerebrum' ),
										'<span class="author_posts_total_value">' . number_format_i18n( $cerebrum_posts_total ) . '</span>'
								 		),
							'cerebrum_kses_content'
							);
			} else {
				esc_html_e( 'No posts published.', 'cerebrum' );
			}
			?>
		</span><?php
			ob_start();
			do_action( 'cerebrum_action_user_meta', 'author-page' );
			$cerebrum_socials = ob_get_contents();
			ob_end_clean();
			cerebrum_show_layout( $cerebrum_socials,
				'<span class="author_socials"><span class="author_socials_caption">' . esc_html__( 'Follow:', 'cerebrum' ) . '</span>',
				'</span>'
			);
		?>
	</div>

</div>
