<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0
 */

$cerebrum_template_args = get_query_var( 'cerebrum_template_args' );

if ( is_array( $cerebrum_template_args ) ) {
	$cerebrum_columns    = empty( $cerebrum_template_args['columns'] ) ? 2 : max( 1, $cerebrum_template_args['columns'] );
	$cerebrum_blog_style = array( $cerebrum_template_args['type'], $cerebrum_columns );
    $cerebrum_columns_class = cerebrum_get_column_class( 1, $cerebrum_columns, ! empty( $cerebrum_template_args['columns_tablet']) ? $cerebrum_template_args['columns_tablet'] : '', ! empty($cerebrum_template_args['columns_mobile']) ? $cerebrum_template_args['columns_mobile'] : '' );
} else {
	$cerebrum_template_args = array();
	$cerebrum_blog_style = explode( '_', cerebrum_get_theme_option( 'blog_style' ) );
	$cerebrum_columns    = empty( $cerebrum_blog_style[1] ) ? 2 : max( 1, $cerebrum_blog_style[1] );
    $cerebrum_columns_class = cerebrum_get_column_class( 1, $cerebrum_columns );
}
$cerebrum_expanded   = ! cerebrum_sidebar_present() && cerebrum_get_theme_option( 'expand_content' ) == 'expand';

$cerebrum_post_format = get_post_format();
$cerebrum_post_format = empty( $cerebrum_post_format ) ? 'standard' : str_replace( 'post-format-', '', $cerebrum_post_format );

?><div class="<?php
	if ( ! empty( $cerebrum_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( cerebrum_is_blog_style_use_masonry( $cerebrum_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $cerebrum_columns ) : esc_attr( $cerebrum_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $cerebrum_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $cerebrum_columns )
				. ' post_layout_' . esc_attr( $cerebrum_blog_style[0] )
				. ' post_layout_' . esc_attr( $cerebrum_blog_style[0] ) . '_' . esc_attr( $cerebrum_columns )
	);
	cerebrum_add_blog_animation( $cerebrum_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$cerebrum_hover      = ! empty( $cerebrum_template_args['hover'] ) && ! cerebrum_is_inherit( $cerebrum_template_args['hover'] )
							? $cerebrum_template_args['hover']
							: cerebrum_get_theme_option( 'image_hover' );

	$cerebrum_components = ! empty( $cerebrum_template_args['meta_parts'] )
							? ( is_array( $cerebrum_template_args['meta_parts'] )
								? $cerebrum_template_args['meta_parts']
								: explode( ',', $cerebrum_template_args['meta_parts'] )
								)
							: cerebrum_array_get_keys_by_value( cerebrum_get_theme_option( 'meta_parts' ) );

	cerebrum_show_post_featured( apply_filters( 'cerebrum_filter_args_featured',
		array(
			'thumb_size' => ! empty( $cerebrum_template_args['thumb_size'] )
				? $cerebrum_template_args['thumb_size']
				: cerebrum_get_thumb_size(
					'classic' == $cerebrum_blog_style[0]
						? ( strpos( cerebrum_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $cerebrum_columns > 2 ? 'big' : 'huge' )
								: ( $cerebrum_columns > 2
									? ( $cerebrum_expanded ? 'square' : 'square' )
									: ($cerebrum_columns > 1 ? 'square' : ( $cerebrum_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( cerebrum_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $cerebrum_columns > 2 ? 'masonry-big' : 'full' )
								: ($cerebrum_columns === 1 ? ( $cerebrum_expanded ? 'huge' : 'big' ) : ( $cerebrum_columns <= 2 && $cerebrum_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $cerebrum_hover,
			'meta_parts' => $cerebrum_components,
			'no_links'   => ! empty( $cerebrum_template_args['no_links'] ),
        ),
        'content-classic',
        $cerebrum_template_args
    ) );

	// Title and post meta
	$cerebrum_show_title = get_the_title() != '';
	$cerebrum_show_meta  = count( $cerebrum_components ) > 0 && ! in_array( $cerebrum_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $cerebrum_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'cerebrum_filter_show_blog_meta', $cerebrum_show_meta, $cerebrum_components, 'classic' ) ) {
				if ( count( $cerebrum_components ) > 0 ) {
					do_action( 'cerebrum_action_before_post_meta' );
					cerebrum_show_post_meta(
						apply_filters(
							'cerebrum_filter_post_meta_args', array(
							'components' => join( ',', $cerebrum_components ),
							'seo'        => false,
							'echo'       => true,
						), $cerebrum_blog_style[0], $cerebrum_columns
						)
					);
					do_action( 'cerebrum_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'cerebrum_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'cerebrum_action_before_post_title' );
				if ( empty( $cerebrum_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'cerebrum_action_after_post_title' );
			}

			if( !in_array( $cerebrum_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'cerebrum_filter_show_blog_readmore', ! $cerebrum_show_title || ! empty( $cerebrum_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $cerebrum_template_args['no_links'] ) ) {
						do_action( 'cerebrum_action_before_post_readmore' );
						cerebrum_show_post_more_link( $cerebrum_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'cerebrum_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $cerebrum_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('cerebrum_filter_show_blog_excerpt', empty($cerebrum_template_args['hide_excerpt']) && cerebrum_get_theme_option('excerpt_length') > 0, 'classic')) {
			cerebrum_show_post_content($cerebrum_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $cerebrum_template_args['more_button'] )) {
			if ( empty( $cerebrum_template_args['no_links'] ) ) {
				do_action( 'cerebrum_action_before_post_readmore' );
				cerebrum_show_post_more_link( $cerebrum_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'cerebrum_action_after_post_readmore' );
			}
		}
		$cerebrum_content = ob_get_contents();
		ob_end_clean();
		cerebrum_show_layout($cerebrum_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
