<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0.50
 */

$cerebrum_template_args = get_query_var( 'cerebrum_template_args' );
if ( is_array( $cerebrum_template_args ) ) {
	$cerebrum_columns    = empty( $cerebrum_template_args['columns'] ) ? 2 : max( 1, $cerebrum_template_args['columns'] );
	$cerebrum_blog_style = array( $cerebrum_template_args['type'], $cerebrum_columns );
} else {
	$cerebrum_template_args = array();
	$cerebrum_blog_style = explode( '_', cerebrum_get_theme_option( 'blog_style' ) );
	$cerebrum_columns    = empty( $cerebrum_blog_style[1] ) ? 2 : max( 1, $cerebrum_blog_style[1] );
}
$cerebrum_blog_id       = cerebrum_get_custom_blog_id( join( '_', $cerebrum_blog_style ) );
$cerebrum_blog_style[0] = str_replace( 'blog-custom-', '', $cerebrum_blog_style[0] );
$cerebrum_expanded      = ! cerebrum_sidebar_present() && cerebrum_get_theme_option( 'expand_content' ) == 'expand';
$cerebrum_components    = ! empty( $cerebrum_template_args['meta_parts'] )
							? ( is_array( $cerebrum_template_args['meta_parts'] )
								? join( ',', $cerebrum_template_args['meta_parts'] )
								: $cerebrum_template_args['meta_parts']
								)
							: cerebrum_array_get_keys_by_value( cerebrum_get_theme_option( 'meta_parts' ) );
$cerebrum_post_format   = get_post_format();
$cerebrum_post_format   = empty( $cerebrum_post_format ) ? 'standard' : str_replace( 'post-format-', '', $cerebrum_post_format );

$cerebrum_blog_meta     = cerebrum_get_custom_layout_meta( $cerebrum_blog_id );
$cerebrum_custom_style  = ! empty( $cerebrum_blog_meta['scripts_required'] ) ? $cerebrum_blog_meta['scripts_required'] : 'none';

if ( ! empty( $cerebrum_template_args['slider'] ) || $cerebrum_columns > 1 || ! cerebrum_is_off( $cerebrum_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $cerebrum_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( cerebrum_is_off( $cerebrum_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $cerebrum_custom_style ) ) . "-1_{$cerebrum_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $cerebrum_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $cerebrum_columns )
					. ' post_layout_' . esc_attr( $cerebrum_blog_style[0] )
					. ' post_layout_' . esc_attr( $cerebrum_blog_style[0] ) . '_' . esc_attr( $cerebrum_columns )
					. ( ! cerebrum_is_off( $cerebrum_custom_style )
						? ' post_layout_' . esc_attr( $cerebrum_custom_style )
							. ' post_layout_' . esc_attr( $cerebrum_custom_style ) . '_' . esc_attr( $cerebrum_columns )
						: ''
						)
		);
	cerebrum_add_blog_animation( $cerebrum_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'cerebrum_action_show_layout', $cerebrum_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $cerebrum_template_args['slider'] ) || $cerebrum_columns > 1 || ! cerebrum_is_off( $cerebrum_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
