<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0
 */

$cerebrum_template_args = get_query_var( 'cerebrum_template_args' );
$cerebrum_columns = 1;
if ( is_array( $cerebrum_template_args ) ) {
	$cerebrum_columns    = empty( $cerebrum_template_args['columns'] ) ? 1 : max( 1, $cerebrum_template_args['columns'] );
	$cerebrum_blog_style = array( $cerebrum_template_args['type'], $cerebrum_columns );
	if ( ! empty( $cerebrum_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $cerebrum_columns > 1 ) {
	    $cerebrum_columns_class = cerebrum_get_column_class( 1, $cerebrum_columns, ! empty( $cerebrum_template_args['columns_tablet']) ? $cerebrum_template_args['columns_tablet'] : '', ! empty($cerebrum_template_args['columns_mobile']) ? $cerebrum_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $cerebrum_columns_class ); ?>">
		<?php
	}
} else {
	$cerebrum_template_args = array();
}
$cerebrum_expanded    = ! cerebrum_sidebar_present() && cerebrum_get_theme_option( 'expand_content' ) == 'expand';
$cerebrum_post_format = get_post_format();
$cerebrum_post_format = empty( $cerebrum_post_format ) ? 'standard' : str_replace( 'post-format-', '', $cerebrum_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $cerebrum_post_format ) );
	cerebrum_add_blog_animation( $cerebrum_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$cerebrum_hover      = ! empty( $cerebrum_template_args['hover'] ) && ! cerebrum_is_inherit( $cerebrum_template_args['hover'] )
							? $cerebrum_template_args['hover']
							: cerebrum_get_theme_option( 'image_hover' );
	$cerebrum_components = ! empty( $cerebrum_template_args['meta_parts'] )
							? ( is_array( $cerebrum_template_args['meta_parts'] )
								? $cerebrum_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $cerebrum_template_args['meta_parts'] ) )
								)
							: cerebrum_array_get_keys_by_value( cerebrum_get_theme_option( 'meta_parts' ) );
	cerebrum_show_post_featured( apply_filters( 'cerebrum_filter_args_featured',
		array(
			'no_links'   => ! empty( $cerebrum_template_args['no_links'] ),
			'hover'      => $cerebrum_hover,
			'meta_parts' => $cerebrum_components,
			'thumb_size' => ! empty( $cerebrum_template_args['thumb_size'] )
							? $cerebrum_template_args['thumb_size']
							: cerebrum_get_thumb_size( strpos( cerebrum_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $cerebrum_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$cerebrum_template_args
	) );

	// Title and post meta
	$cerebrum_show_title = get_the_title() != '';
	$cerebrum_show_meta  = count( $cerebrum_components ) > 0 && ! in_array( $cerebrum_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $cerebrum_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'cerebrum_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'cerebrum_action_before_post_title' );
				if ( empty( $cerebrum_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'cerebrum_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'cerebrum_filter_show_blog_excerpt', empty( $cerebrum_template_args['hide_excerpt'] ) && cerebrum_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'cerebrum_filter_show_blog_meta', $cerebrum_show_meta, $cerebrum_components, 'excerpt' ) ) {
				if ( count( $cerebrum_components ) > 0 ) {
					do_action( 'cerebrum_action_before_post_meta' );
					cerebrum_show_post_meta(
						apply_filters(
							'cerebrum_filter_post_meta_args', array(
								'components' => join( ',', $cerebrum_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'cerebrum_action_after_post_meta' );
				}
			}

			if ( cerebrum_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'cerebrum_action_before_full_post_content' );
					the_content( '' );
					do_action( 'cerebrum_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'cerebrum' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'cerebrum' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				cerebrum_show_post_content( $cerebrum_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'cerebrum_filter_show_blog_readmore',  ! isset( $cerebrum_template_args['more_button'] ) || ! empty( $cerebrum_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $cerebrum_template_args['no_links'] ) ) {
					do_action( 'cerebrum_action_before_post_readmore' );
					if ( cerebrum_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						cerebrum_show_post_more_link( $cerebrum_template_args, '<p>', '</p>' );
					} else {
						cerebrum_show_post_comments_link( $cerebrum_template_args, '<p>', '</p>' );
					}
					do_action( 'cerebrum_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $cerebrum_template_args ) ) {
	if ( ! empty( $cerebrum_template_args['slider'] ) || $cerebrum_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
