<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0
 */

$cerebrum_template_args = get_query_var( 'cerebrum_template_args' );
if ( is_array( $cerebrum_template_args ) ) {
	$cerebrum_columns    = empty( $cerebrum_template_args['columns'] ) ? 2 : max( 1, $cerebrum_template_args['columns'] );
	$cerebrum_blog_style = array( $cerebrum_template_args['type'], $cerebrum_columns );
    $cerebrum_columns_class = cerebrum_get_column_class( 1, $cerebrum_columns, ! empty( $cerebrum_template_args['columns_tablet']) ? $cerebrum_template_args['columns_tablet'] : '', ! empty($cerebrum_template_args['columns_mobile']) ? $cerebrum_template_args['columns_mobile'] : '' );
} else {
	$cerebrum_template_args = array();
	$cerebrum_blog_style = explode( '_', cerebrum_get_theme_option( 'blog_style' ) );
	$cerebrum_columns    = empty( $cerebrum_blog_style[1] ) ? 2 : max( 1, $cerebrum_blog_style[1] );
    $cerebrum_columns_class = cerebrum_get_column_class( 1, $cerebrum_columns );
}

$cerebrum_post_format = get_post_format();
$cerebrum_post_format = empty( $cerebrum_post_format ) ? 'standard' : str_replace( 'post-format-', '', $cerebrum_post_format );

?><div class="
<?php
if ( ! empty( $cerebrum_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( cerebrum_is_blog_style_use_masonry( $cerebrum_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $cerebrum_columns ) : esc_attr( $cerebrum_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $cerebrum_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $cerebrum_columns )
		. ( 'portfolio' != $cerebrum_blog_style[0] ? ' ' . esc_attr( $cerebrum_blog_style[0] )  . '_' . esc_attr( $cerebrum_columns ) : '' )
	);
	cerebrum_add_blog_animation( $cerebrum_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	$cerebrum_hover   = ! empty( $cerebrum_template_args['hover'] ) && ! cerebrum_is_inherit( $cerebrum_template_args['hover'] )
								? $cerebrum_template_args['hover']
								: cerebrum_get_theme_option( 'image_hover' );

	if ( 'dots' == $cerebrum_hover ) {
		$cerebrum_post_link = empty( $cerebrum_template_args['no_links'] )
								? ( ! empty( $cerebrum_template_args['link'] )
									? $cerebrum_template_args['link']
									: get_permalink()
									)
								: '';
		$cerebrum_target    = ! empty( $cerebrum_post_link ) && cerebrum_is_external_url( $cerebrum_post_link ) && function_exists( 'cerebrum_external_links_target' )
								? cerebrum_external_links_target()
								: '';
	}
	
	// Meta parts
	$cerebrum_components = ! empty( $cerebrum_template_args['meta_parts'] )
							? ( is_array( $cerebrum_template_args['meta_parts'] )
								? $cerebrum_template_args['meta_parts']
								: explode( ',', $cerebrum_template_args['meta_parts'] )
								)
							: cerebrum_array_get_keys_by_value( cerebrum_get_theme_option( 'meta_parts' ) );

	// Featured image
	cerebrum_show_post_featured( apply_filters( 'cerebrum_filter_args_featured', 
        array(
			'hover'         => $cerebrum_hover,
			'no_links'      => ! empty( $cerebrum_template_args['no_links'] ),
			'thumb_size'    => ! empty( $cerebrum_template_args['thumb_size'] )
								? $cerebrum_template_args['thumb_size']
								: cerebrum_get_thumb_size(
									cerebrum_is_blog_style_use_masonry( $cerebrum_blog_style[0] )
										? (	strpos( cerebrum_get_theme_option( 'body_style' ), 'full' ) !== false || $cerebrum_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( cerebrum_get_theme_option( 'body_style' ), 'full' ) !== false || $cerebrum_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => cerebrum_is_blog_style_use_masonry( $cerebrum_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $cerebrum_components,
			'class'         => 'dots' == $cerebrum_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $cerebrum_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $cerebrum_post_link )
												? '<a href="' . esc_url( $cerebrum_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $cerebrum_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $cerebrum_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $cerebrum_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!