<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$cerebrum_copyright_scheme = cerebrum_get_theme_option( 'copyright_scheme' );
if ( ! empty( $cerebrum_copyright_scheme ) && ! cerebrum_is_inherit( $cerebrum_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $cerebrum_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$cerebrum_copyright = cerebrum_get_theme_option( 'copyright' );
			if ( ! empty( $cerebrum_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$cerebrum_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $cerebrum_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$cerebrum_copyright = cerebrum_prepare_macros( $cerebrum_copyright );
				// Display copyright
				echo wp_kses( nl2br( $cerebrum_copyright ), 'cerebrum_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
