<?php
/**
 * The template to display default site footer
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0.10
 */

$cerebrum_footer_id = cerebrum_get_custom_footer_id();
$cerebrum_footer_meta = get_post_meta( $cerebrum_footer_id, 'trx_addons_options', true );
if ( ! empty( $cerebrum_footer_meta['margin'] ) ) {
	cerebrum_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( cerebrum_prepare_css_value( $cerebrum_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $cerebrum_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $cerebrum_footer_id ) ) ); ?>
						<?php
						$cerebrum_footer_scheme = cerebrum_get_theme_option( 'footer_scheme' );
						if ( ! empty( $cerebrum_footer_scheme ) && ! cerebrum_is_inherit( $cerebrum_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $cerebrum_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'cerebrum_action_show_layout', $cerebrum_footer_id );
	?>
</footer><!-- /.footer_wrap -->
