<?php
/**
 * The template to display the site logo in the footer
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0.10
 */

// Logo
if ( cerebrum_is_on( cerebrum_get_theme_option( 'logo_in_footer' ) ) ) {
	$cerebrum_logo_image = cerebrum_get_logo_image( 'footer' );
	$cerebrum_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $cerebrum_logo_image['logo'] ) || ! empty( $cerebrum_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $cerebrum_logo_image['logo'] ) ) {
					$cerebrum_attr = cerebrum_getimagesize( $cerebrum_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $cerebrum_logo_image['logo'] ) . '"'
								. ( ! empty( $cerebrum_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $cerebrum_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'cerebrum' ) . '"'
								. ( ! empty( $cerebrum_attr[3] ) ? ' ' . wp_kses_data( $cerebrum_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $cerebrum_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $cerebrum_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
