<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0.10
 */

// Footer sidebar
$cerebrum_footer_name    = cerebrum_get_theme_option( 'footer_widgets' );
$cerebrum_footer_present = ! cerebrum_is_off( $cerebrum_footer_name ) && is_active_sidebar( $cerebrum_footer_name );
if ( $cerebrum_footer_present ) {
	cerebrum_storage_set( 'current_sidebar', 'footer' );
	$cerebrum_footer_wide = cerebrum_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $cerebrum_footer_name ) ) {
		dynamic_sidebar( $cerebrum_footer_name );
	}
	$cerebrum_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $cerebrum_out ) ) {
		$cerebrum_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $cerebrum_out );
		$cerebrum_need_columns = true;   //or check: strpos($cerebrum_out, 'columns_wrap')===false;
		if ( $cerebrum_need_columns ) {
			$cerebrum_columns = max( 0, (int) cerebrum_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $cerebrum_columns ) {
				$cerebrum_columns = min( 4, max( 1, cerebrum_tags_count( $cerebrum_out, 'aside' ) ) );
			}
			if ( $cerebrum_columns > 1 ) {
				$cerebrum_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $cerebrum_columns ) . ' widget', $cerebrum_out );
			} else {
				$cerebrum_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $cerebrum_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'cerebrum_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $cerebrum_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $cerebrum_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'cerebrum_action_before_sidebar', 'footer' );
				cerebrum_show_layout( $cerebrum_out );
				do_action( 'cerebrum_action_after_sidebar', 'footer' );
				if ( $cerebrum_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $cerebrum_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'cerebrum_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
