<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0.06
 */

$cerebrum_header_css   = '';
$cerebrum_header_image = get_header_image();
$cerebrum_header_video = cerebrum_get_header_video();
if ( ! empty( $cerebrum_header_image ) && cerebrum_trx_addons_featured_image_override( is_singular() || cerebrum_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$cerebrum_header_image = cerebrum_get_current_mode_image( $cerebrum_header_image );
}

$cerebrum_header_id = cerebrum_get_custom_header_id();
$cerebrum_header_meta = get_post_meta( $cerebrum_header_id, 'trx_addons_options', true );
if ( ! empty( $cerebrum_header_meta['margin'] ) ) {
	cerebrum_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( cerebrum_prepare_css_value( $cerebrum_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $cerebrum_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $cerebrum_header_id ) ) ); ?>
				<?php
				echo ! empty( $cerebrum_header_image ) || ! empty( $cerebrum_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $cerebrum_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $cerebrum_header_image ) {
					echo ' ' . esc_attr( cerebrum_add_inline_css_class( 'background-image: url(' . esc_url( $cerebrum_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( cerebrum_is_on( cerebrum_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight cerebrum-full-height';
				}
				$cerebrum_header_scheme = cerebrum_get_theme_option( 'header_scheme' );
				if ( ! empty( $cerebrum_header_scheme ) && ! cerebrum_is_inherit( $cerebrum_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $cerebrum_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $cerebrum_header_video ) ) {
		get_template_part( apply_filters( 'cerebrum_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'cerebrum_action_show_layout', $cerebrum_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'cerebrum_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
