<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0
 */

$cerebrum_args = get_query_var( 'cerebrum_logo_args' );

// Site logo
$cerebrum_logo_type   = isset( $cerebrum_args['type'] ) ? $cerebrum_args['type'] : '';
$cerebrum_logo_image  = cerebrum_get_logo_image( $cerebrum_logo_type );
$cerebrum_logo_text   = cerebrum_is_on( cerebrum_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$cerebrum_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $cerebrum_logo_image['logo'] ) || ! empty( $cerebrum_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $cerebrum_logo_image['logo'] ) ) {
			if ( empty( $cerebrum_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($cerebrum_logo_image['logo']) && (int) $cerebrum_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$cerebrum_attr = cerebrum_getimagesize( $cerebrum_logo_image['logo'] );
				echo '<img src="' . esc_url( $cerebrum_logo_image['logo'] ) . '"'
						. ( ! empty( $cerebrum_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $cerebrum_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $cerebrum_logo_text ) . '"'
						. ( ! empty( $cerebrum_attr[3] ) ? ' ' . wp_kses_data( $cerebrum_attr[3] ) : '' )
						. '>';
			}
		} else {
			cerebrum_show_layout( cerebrum_prepare_macros( $cerebrum_logo_text ), '<span class="logo_text">', '</span>' );
			cerebrum_show_layout( cerebrum_prepare_macros( $cerebrum_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
