<?php
/**
 * The template to display the side menu
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0
 */
?>
<div class="menu_side_wrap
<?php
echo ' menu_side_' . esc_attr( cerebrum_get_theme_option( 'menu_side_icons' ) > 0 ? 'icons' : 'dots' );
$cerebrum_menu_scheme = cerebrum_get_theme_option( 'menu_scheme' );
$cerebrum_header_scheme = cerebrum_get_theme_option( 'header_scheme' );
if ( ! empty( $cerebrum_menu_scheme ) && ! cerebrum_is_inherit( $cerebrum_menu_scheme  ) ) {
	echo ' scheme_' . esc_attr( $cerebrum_menu_scheme );
} elseif ( ! empty( $cerebrum_header_scheme ) && ! cerebrum_is_inherit( $cerebrum_header_scheme ) ) {
	echo ' scheme_' . esc_attr( $cerebrum_header_scheme );
}
?>
				">
	<span class="menu_side_button icon-menu-2"></span>

	<div class="menu_side_inner">
		<?php
		// Logo
		set_query_var( 'cerebrum_logo_args', array( 'type' => 'side' ) );
		get_template_part( apply_filters( 'cerebrum_filter_get_template_part', 'templates/header-logo' ) );
		set_query_var( 'cerebrum_logo_args', array() );
		// Main menu button
		?>
		<div class="toc_menu_item"
			<?php
			if ( cerebrum_mouse_helper_enabled() ) {
				echo ' data-mouse-helper="click" data-mouse-helper-axis="y" data-mouse-helper-text="' . esc_attr__( 'Open main menu', 'cerebrum' ) . '"';
			}
			?>
		>
			<a href="#" role="button" class="toc_menu_description menu_mobile_description"><span class="toc_menu_description_title"><?php esc_html_e( 'Main menu', 'cerebrum' ); ?></span></a>
			<a class="menu_mobile_button toc_menu_icon icon-menu-2" href="#" role="button"></a>
		</div>		
	</div>

</div>