<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0
 */

// Page (category, tag, archive, author) title

if ( cerebrum_need_page_title() ) {
	cerebrum_sc_layouts_showed( 'title', true );
	cerebrum_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								cerebrum_show_post_meta(
									apply_filters(
										'cerebrum_filter_post_meta_args', array(
											'components' => join( ',', cerebrum_array_get_keys_by_value( cerebrum_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', cerebrum_array_get_keys_by_value( cerebrum_get_theme_option( 'counters' ) ) ),
											'seo'        => cerebrum_is_on( cerebrum_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$cerebrum_blog_title           = cerebrum_get_blog_title();
							$cerebrum_blog_title_text      = '';
							$cerebrum_blog_title_class     = '';
							$cerebrum_blog_title_link      = '';
							$cerebrum_blog_title_link_text = '';
							if ( is_array( $cerebrum_blog_title ) ) {
								$cerebrum_blog_title_text      = $cerebrum_blog_title['text'];
								$cerebrum_blog_title_class     = ! empty( $cerebrum_blog_title['class'] ) ? ' ' . $cerebrum_blog_title['class'] : '';
								$cerebrum_blog_title_link      = ! empty( $cerebrum_blog_title['link'] ) ? $cerebrum_blog_title['link'] : '';
								$cerebrum_blog_title_link_text = ! empty( $cerebrum_blog_title['link_text'] ) ? $cerebrum_blog_title['link_text'] : '';
							} else {
								$cerebrum_blog_title_text = $cerebrum_blog_title;
							}
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr( $cerebrum_blog_title_class ); ?>"<?php
								if ( cerebrum_is_on( cerebrum_get_theme_option( 'seo_snippets' ) ) ) {
									?> itemprop="headline"<?php
								}
							?>>
								<?php
								$cerebrum_top_icon = cerebrum_get_term_image_small();
								if ( ! empty( $cerebrum_top_icon ) ) {
									$cerebrum_attr = cerebrum_getimagesize( $cerebrum_top_icon );
									?>
									<img src="<?php echo esc_url( $cerebrum_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'cerebrum' ); ?>"
										<?php
										if ( ! empty( $cerebrum_attr[3] ) ) {
											cerebrum_show_layout( $cerebrum_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $cerebrum_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $cerebrum_blog_title_link ) && ! empty( $cerebrum_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $cerebrum_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $cerebrum_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'cerebrum_action_breadcrumbs' );
						$cerebrum_breadcrumbs = ob_get_contents();
						ob_end_clean();
						cerebrum_show_layout( $cerebrum_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
