<?php
/**
 * The template to display the widgets area in the header
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0
 */

// Header sidebar
$cerebrum_header_name    = cerebrum_get_theme_option( 'header_widgets' );
$cerebrum_header_present = ! cerebrum_is_off( $cerebrum_header_name ) && is_active_sidebar( $cerebrum_header_name );
if ( $cerebrum_header_present ) {
	cerebrum_storage_set( 'current_sidebar', 'header' );
	$cerebrum_header_wide = cerebrum_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $cerebrum_header_name ) ) {
		dynamic_sidebar( $cerebrum_header_name );
	}
	$cerebrum_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $cerebrum_widgets_output ) ) {
		$cerebrum_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $cerebrum_widgets_output );
		$cerebrum_need_columns   = strpos( $cerebrum_widgets_output, 'columns_wrap' ) === false;
		if ( $cerebrum_need_columns ) {
			$cerebrum_columns = max( 0, (int) cerebrum_get_theme_option( 'header_columns' ) );
			if ( 0 == $cerebrum_columns ) {
				$cerebrum_columns = min( 6, max( 1, cerebrum_tags_count( $cerebrum_widgets_output, 'aside' ) ) );
			}
			if ( $cerebrum_columns > 1 ) {
				$cerebrum_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $cerebrum_columns ) . ' widget', $cerebrum_widgets_output );
			} else {
				$cerebrum_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $cerebrum_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'cerebrum_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $cerebrum_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $cerebrum_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'cerebrum_action_before_sidebar', 'header' );
				cerebrum_show_layout( $cerebrum_widgets_output );
				do_action( 'cerebrum_action_after_sidebar', 'header' );
				if ( $cerebrum_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $cerebrum_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'cerebrum_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
