<?php
/**
 * The template to display Admin notices
 *
 * @package CEREBRUM
 * @since CEREBRUM 1.0.64
 */

$cerebrum_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$cerebrum_skins_args = get_query_var( 'cerebrum_skins_notice_args' );
?>
<div class="cerebrum_admin_notice cerebrum_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$cerebrum_theme_img = cerebrum_get_file_url( 'screenshot.jpg' );
	if ( '' != $cerebrum_theme_img ) {
		?>
		<div class="cerebrum_notice_image"><img src="<?php echo esc_url( $cerebrum_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'cerebrum' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="cerebrum_notice_title">
		<?php esc_html_e( 'New skins are available', 'cerebrum' ); ?>
	</h3>
	<?php

	// Description
	$cerebrum_total      = $cerebrum_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$cerebrum_skins_msg  = $cerebrum_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $cerebrum_total, 'cerebrum' ), $cerebrum_total ) . '</strong>'
							: '';
	$cerebrum_total      = $cerebrum_skins_args['free'];
	$cerebrum_skins_msg .= $cerebrum_total > 0
							? ( ! empty( $cerebrum_skins_msg ) ? ' ' . esc_html__( 'and', 'cerebrum' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $cerebrum_total, 'cerebrum' ), $cerebrum_total ) . '</strong>'
							: '';
	$cerebrum_total      = $cerebrum_skins_args['pay'];
	$cerebrum_skins_msg .= $cerebrum_skins_args['pay'] > 0
							? ( ! empty( $cerebrum_skins_msg ) ? ' ' . esc_html__( 'and', 'cerebrum' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $cerebrum_total, 'cerebrum' ), $cerebrum_total ) . '</strong>'
							: '';
	?>
	<div class="cerebrum_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'cerebrum' ), $cerebrum_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="cerebrum_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $cerebrum_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			esc_html_e( 'Go to Skins manager', 'cerebrum' );
			?>
		</a>
		<?php
		// Dismiss notice for 7 days
		?>
		<a href="#" role="button" class="button button-secondary cerebrum_notice_button_dismiss" data-notice="skins"><i class="dashicons dashicons-no-alt"></i> 
			<?php
			esc_html_e( 'Dismiss', 'cerebrum' );
			?>
		</a>
		<?php
		// Hide notice forever
		?>
		<a href="#" role="button" class="button button-secondary cerebrum_notice_button_hide" data-notice="skins"><i class="dashicons dashicons-no-alt"></i> 
			<?php
			esc_html_e( 'Never show again', 'cerebrum' );
			?>
		</a>
	</div>
</div>
